<?php
/**
 * فایل نمایش نظرات - طراحی مدرن و جذاب
 */
if (post_password_required()) {
    return;
}
?>

<div id="comments" class="comments-area-modern">
    <?php if (have_comments()) : ?>
        <h2 class="comments-title-modern">
            💬 
            <?php
            $comments_number = get_comments_number();
            if ($comments_number == 1) {
                echo 'یک نظر';
            } else {
                printf('%s نظر', number_format_i18n($comments_number));
            }
            ?>
        </h2>

        <ol class="comment-list-modern">
            <?php
            wp_list_comments([
                'style'       => 'ol',
                'short_ping'  => true,
                'avatar_size' => 64,
                'callback'    => 'modern_comment_template',
            ]);
            ?>
        </ol>

        <?php if (get_comment_pages_count() > 1 && get_option('page_comments')) : ?>
            <nav class="comment-navigation-modern">
                <?php paginate_comments_links([
                    'prev_text' => '← نظرات قبلی',
                    'next_text' => 'نظرات بعدی →',
                ]); ?>
            </nav>
        <?php endif; ?>

    <?php endif; ?>

    <?php if (!comments_open() && get_comments_number() && post_type_supports(get_post_type(), 'comments')) : ?>
        <p class="no-comments-modern">🔒 امکان ثبت نظر جدید وجود ندارد.</p>
    <?php endif; ?>

    <?php
    // فرم ارسال نظر مدرن
    comment_form([
        'title_reply'          => '<span class="reply-icon">✍️</span> نظر خود را بنویسید',
        'title_reply_to'       => '<span class="reply-icon">✍️</span> پاسخ به %s',
        'cancel_reply_link'    => '✖ انصراف',
        'label_submit'         => '🚀 ارسال نظر',
        'class_submit'         => 'submit-modern',
        'comment_field'        => '<p class="comment-form-comment-modern"><label for="comment">پیام شما</label><textarea id="comment" name="comment" rows="6" required placeholder="نظر خود را اینجا بنویسید..."></textarea></p>',
        'fields'               => [
            'author' => '<p class="comment-form-author-modern"><label for="author">نام *</label><input id="author" name="author" type="text" required placeholder="نام شما"></p>',
            'email'  => '<p class="comment-form-email-modern"><label for="email">ایمیل *</label><input id="email" name="email" type="email" required placeholder="ایمیل شما"></p>',
            'url'    => '<p class="comment-form-url-modern"><label for="url">وبسایت</label><input id="url" name="url" type="url" placeholder="آدرس وبسایت (اختیاری)"></p>',
        ],
        'class_form'           => 'comment-form-modern',
        'comment_notes_before' => '',
        'comment_notes_after'  => '',
    ]);
    ?>
</div>

<style>
/* ===== استایل‌های مدرن و جذاب بخش نظرات ===== */
.comments-area-modern {
    margin: 60px 0;
    padding: 48px 40px;
    background: white;
    border-radius: 24px;
    box-shadow: 0 15px 50px rgba(0,0,0,0.08);
}

/* تیتر نظرات */
.comments-title-modern {
    font-size: 2rem;
    font-weight: 900;
    text-align: center;
    margin-bottom: 48px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 12px;
}

/* لیست نظرات */
.comment-list-modern {
    list-style: none;
    padding: 0;
    margin: 0 0 48px 0;
}

.comment-list-modern .comment {
    margin-bottom: 32px;
}

/* باکس نظر مدرن */
.comment-body-modern {
    background: linear-gradient(135deg, #f5f7fa 0%, #fdfeff 100%);
    border-radius: 20px;
    padding: 32px;
    box-shadow: 0 10px 30px rgba(0,0,0,0.06);
    border: 1px solid rgba(102, 126, 234, 0.1);
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
}

.comment-body-modern::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    width: 5px;
    height: 100%;
    background: linear-gradient(180deg, #667eea 0%, #764ba2 100%);
}

.comment-body-modern:hover {
    transform: translateX(-5px);
    box-shadow: 0 15px 40px rgba(102, 126, 234, 0.15);
}

/* هدر نظر */
.comment-header-modern {
    display: flex;
    align-items: center;
    gap: 16px;
    margin-bottom: 20px;
}

.comment-author-modern {
    display: flex;
    align-items: center;
    gap: 16px;
    flex: 1;
}

.comment-author-modern .avatar {
    border-radius: 50%;
    border: 3px solid white;
    box-shadow: 0 6px 20px rgba(102, 126, 234, 0.25);
}

.author-info-modern {
    display: flex;
    flex-direction: column;
    gap: 4px;
}

.comment-author-modern .fn {
    font-size: 1.1rem;
    font-weight: 800;
    color: #2c3e50;
    margin: 0;
    text-decoration: none;
}

.comment-metadata-modern {
    display: flex;
    align-items: center;
    gap: 8px;
    font-size: 0.85rem;
    color: #999;
    font-weight: 600;
}

.comment-metadata-modern a {
    color: #999;
    text-decoration: none;
    transition: color 0.2s;
}

.comment-metadata-modern a:hover {
    color: #667eea;
}

/* محتوای نظر */
.comment-content-modern {
    color: #444;
    font-size: 1.05rem;
    line-height: 1.8;
    margin: 20px 0;
}

.comment-content-modern p {
    margin-bottom: 16px;
}

/* دکمه پاسخ */
.reply-modern {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white !important;
    padding: 10px 24px;
    border-radius: 50px;
    text-decoration: none;
    font-weight: 700;
    font-size: 0.9rem;
    box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
    transition: all 0.3s ease;
}

.reply-modern:hover {
    transform: translateY(-3px);
    box-shadow: 0 8px 25px rgba(102, 126, 234, 0.5);
}

/* نظرات سطح دوم و سوم */
.comment-list-modern .children {
    list-style: none;
    padding: 0;
    margin: 32px 0 0 40px;
}

.comment-list-modern .children .comment-body-modern {
    background: linear-gradient(135deg, #fff5f8 0%, #ffffff 100%);
    border-left-color: rgba(245, 87, 108, 0.2);
}

.comment-list-modern .children .comment-body-modern::before {
    background: linear-gradient(180deg, #f093fb 0%, #f5576c 100%);
}

/* فرم ارسال نظر مدرن */
.comment-form-modern {
    background: linear-gradient(135deg, #f5f7fa 0%, #ffffff 100%);
    padding: 40px;
    border-radius: 20px;
    box-shadow: 0 10px 40px rgba(0,0,0,0.06);
    border: 2px solid rgba(102, 126, 234, 0.1);
}

#reply-title {
    font-size: 1.6rem;
    font-weight: 900;
    color: #2c3e50;
    margin-bottom: 32px;
    display: flex;
    align-items: center;
    gap: 12px;
}

#cancel-comment-reply-link {
    font-size: 0.9rem;
    color: #f5576c;
    text-decoration: none;
    font-weight: 700;
    margin-right: 16px;
    transition: all 0.2s;
}

#cancel-comment-reply-link:hover {
    color: #d43f5a;
}

.comment-form-modern label {
    display: block;
    font-weight: 700;
    color: #2c3e50;
    margin-bottom: 8px;
    font-size: 0.95rem;
}

.comment-form-modern input[type="text"],
.comment-form-modern input[type="email"],
.comment-form-modern input[type="url"],
.comment-form-modern textarea {
    width: 100%;
    padding: 14px 18px;
    border: 2px solid #e8ecf3;
    border-radius: 12px;
    font-size: 1rem;
    font-family: 'Vazir', sans-serif;
    transition: all 0.3s ease;
    background: white;
}

.comment-form-modern input:focus,
.comment-form-modern textarea:focus {
    outline: none;
    border-color: #667eea;
    box-shadow: 0 0 0 4px rgba(102, 126, 234, 0.1);
}

.comment-form-author-modern,
.comment-form-email-modern,
.comment-form-url-modern,
.comment-form-comment-modern {
    margin-bottom: 24px;
}

.comment-form-modern textarea {
    resize: vertical;
    min-height: 140px;
}

/* دکمه ارسال */
.form-submit {
    margin: 0;
    text-align: center;
}

.submit-modern {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    border: none;
    padding: 16px 48px;
    border-radius: 50px;
    font-size: 1.1rem;
    font-weight: 800;
    cursor: pointer;
    box-shadow: 0 6px 25px rgba(102, 126, 234, 0.4);
    transition: all 0.3s ease;
    display: inline-flex;
    align-items: center;
    gap: 10px;
}

.submit-modern:hover {
    transform: translateY(-4px);
    box-shadow: 0 10px 35px rgba(102, 126, 234, 0.6);
}

.submit-modern:active {
    transform: translateY(-2px);
}

/* پیام در انتظار تایید */
.comment-awaiting-moderation {
    background: linear-gradient(135deg, #fff3cd 0%, #fff9e6 100%);
    border: 2px solid #ffc107;
    color: #856404;
    padding: 14px 20px;
    border-radius: 12px;
    font-weight: 700;
    margin: 16px 0;
    display: flex;
    align-items: center;
    gap: 10px;
}

.comment-awaiting-moderation::before {
    content: '⏳';
    font-size: 1.3rem;
}

/* پیام عدم امکان نظر */
.no-comments-modern {
    text-align: center;
    padding: 40px;
    background: linear-gradient(135deg, #f5f7fa 0%, #e8ecf3 100%);
    border-radius: 16px;
    font-size: 1.1rem;
    font-weight: 700;
    color: #666;
}

/* ریسپانسیو */
@media (max-width: 768px) {
    .comments-area-modern {
        padding: 32px 20px;
    }
    
    .comment-body-modern {
        padding: 24px 20px;
    }
    
    .comment-list-modern .children {
        margin-left: 20px;
    }
    
    .comment-form-modern {
        padding: 28px 20px;
    }
    
    .submit-modern {
        width: 100%;
        justify-content: center;
    }
}
</style>

<?php
/**
 * تابع سفارشی برای نمایش نظرات
 */
function modern_comment_template($comment, $args, $depth) {
    ?>
    <li <?php comment_class('comment'); ?> id="comment-<?php comment_ID(); ?>">
        <div class="comment-body-modern">
            <div class="comment-header-modern">
                <div class="comment-author-modern vcard">
                    <?php echo get_avatar($comment, 64); ?>
                    <div class="author-info-modern">
                        <?php printf('<cite class="fn">%s</cite>', get_comment_author_link()); ?>
                        <div class="comment-metadata-modern">
                            <span>🕐</span>
                            <a href="<?php echo esc_url(get_comment_link($comment, $args)); ?>">
                                <?php printf('%s', get_comment_date('d F Y - H:i')); ?>
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <div class="comment-content-modern">
                <?php comment_text(); ?>
            </div>

            <?php if ($comment->comment_approved == '0') : ?>
                <p class="comment-awaiting-moderation">نظر شما در انتظار تایید است.</p>
            <?php endif; ?>

            <?php
            comment_reply_link(array_merge($args, [
                'depth'      => $depth,
                'max_depth'  => $args['max_depth'],
                'reply_text' => '↩️ پاسخ',
                'before'     => '<div class="reply">',
                'after'      => '</div>',
                'class'      => 'reply-modern',
            ]));
            ?>
        </div>
    <?php
}
?>

