<?php
$footerBg = get_option('abad_header_footer_color', '#2b2b2b');
$footer_logo = get_option('abad_footer_logo', '');
$footer_contact = nl2br(esc_html(get_option('abad_footer_contact', "آدرس: تهران، سعادت‌آباد، برج آراد\nتلفن: 021-00000\nایمیل: info@aradbranding.com")));
$footer_links = get_option('abad_footer_quicklinks', []);
$footer_copy = get_option('abad_footer_copyright', '© '.date('Y').' - تمامی حقوق متعلق به آرادبرندینگ است.');
?>
<footer class="site-footer" style="background: <?php echo esc_attr($footerBg); ?>;">
  <div class="footer-main">
    <div class="footer-col footer-brand">
      <?php
        if (!empty($footer_logo)) {
          echo '<img src="'.esc_url($footer_logo).'" alt="logo" class="footer-logo">';
        } else {
          echo '<span class="footer-logo-placeholder">ab</span>';
        }
      ?>
      <div class="footer-contact">
        <?php echo $footer_contact; ?>
      </div>
    </div>
    <div class="footer-col footer-menu">
      <?php
      wp_nav_menu([
        'theme_location' => 'footer-menu',
        'container'      => false,
        'menu_class'     => 'footer-main-menu',
        'fallback_cb'    => false,
      ]);
      ?>
    </div>
    <div class="footer-col footer-links">
      <h4>دسترسی سریع</h4>
      <ul class="footer-quick-links">
        <?php if (is_array($footer_links) && count($footer_links)) {
          foreach($footer_links as $item) {
            $title = trim($item[0]); $url = trim($item[1]);
            if(!$title || !$url) continue;
            echo '<li><a href="'.esc_url($url).'">'.esc_html($title).'</a></li>';
          }
        } ?>
      </ul>
    </div>
  </div>
  <div class="footer-copy"><?php echo $footer_copy; ?></div>
</footer>
<style>
.site-footer {color:#eee;margin:0;padding:0;box-sizing:border-box;font-family: Vazir, Tahoma, Arial, sans-serif;font-size: 16px;}
.footer-main {display:flex;gap:38px;max-width:1400px;margin:0 auto;padding:35px 24px 11px 24px;justify-content:space-between;box-sizing:border-box;border-bottom:1.5px solid #3c3c3c;}
.footer-col {display:flex;flex-direction:column;gap:16px;flex:1;min-width:200px;align-items:flex-start;}
.footer-brand {max-width:280px;}
.footer-logo {max-height:53px;width:auto; margin-bottom:8px;border-radius:10px;}
.footer-logo-placeholder{font-size:2.7rem;font-weight:bold;color:#ffd062; padding:10px 0;letter-spacing:4px;background:rgba(50,50,45,.10);border-radius:9px;}
.footer-contact p{margin:0 0 5px 0;color:#c6c6c6;font-size:15px;}
.footer-contact a{color:#e3d16d;text-decoration:none;}
.footer-main-menu {list-style:none;padding:0;margin:0;display:flex;flex-direction:column;gap:8px;}
.footer-main-menu li a{color:#fff;text-decoration:none;padding:4px 0;font-size:16px;border-radius:5px;transition:background .18s,color .18s;}
.footer-main-menu li a:hover{color:#ffd062;background:#393939;}
.footer-links h4 {margin: 0 0 7px 0; color: #ffd062;font-size: 18px;}
.footer-quick-links{list-style:none;padding:0;margin:0;display:flex;flex-direction:column;gap:7px;}
.footer-quick-links a{color:#ffd062;text-decoration:none;font-size:15px;transition:color .16s;}
.footer-quick-links a:hover{color:#fff;text-decoration:underline;}
.footer-copy{text-align:center;font-size:13.7px;color:#b2b2b2;padding:14px;margin-top:0;background:#252525;letter-spacing:.4px;}
@media (max-width:850px){.footer-main{flex-direction:column;gap:23px;padding:19px 10px}.footer-col{min-width:110px}}
</style>
<?php wp_footer(); ?>
</body>
</html>
