<?php
// افزودن پشتیبانی از ترجمه
add_action('after_setup_theme', function () {
    load_theme_textdomain('aradbranding-shop-wp', get_template_directory() . '/languages');
});
// افزودن استایل اصلی پوسته
add_action('wp_enqueue_scripts', function () {
    wp_enqueue_style('aradbranding-shop-wp-style', get_stylesheet_uri());
});

// افزودن فونت وزیر به قالب
add_action('wp_enqueue_scripts', function () {
    wp_enqueue_style('vazir-font', 'https://cdn.fontcdn.ir/Font/Persian/Vazir/Vazir.css', [], null);
}, 1);

// افزودن فونت وزیر به پنل مدیریت و تنظیمات قالب
add_action('admin_enqueue_scripts', function ($hook) {
    wp_enqueue_style('vazir-font-admin', 'https://cdn.fontcdn.ir/Font/Persian/Vazir/Vazir.css', [], null);
    echo '<style>body, h1, h2, h3, h4, h5, h6, input, button, select, textarea { font-family: Vazir, Tahoma, Arial, sans-serif !important; }</style>';
    
    // فعال‌سازی Color Picker در صفحه تنظیمات قالب
    if ('appearance_page_aradbranding-shop-wp-settings' === $hook) {
        wp_enqueue_style('wp-color-picker');
        wp_enqueue_script('wp-color-picker');
        wp_enqueue_media();
    }
});

// افزودن پشتیبانی از post-thumbnails به قالب (ضروری برای custom post types)
add_theme_support('post-thumbnails');

// افزودن لوگو در هدر سایت
add_theme_support('custom-logo', [
    'height'      => 60,
    'width'       => 60,
    'flex-height' => true,
    'flex-width'  => true,
]);

// افزودن صفحه تنظیمات اختصاصی قالب در پیشخوان وردپرس
add_action('admin_menu', function () {
    add_theme_page(
        __('تنظیمات قالب', 'aradbranding-shop-wp'),
        __('تنظیمات قالب', 'aradbranding-shop-wp'),
        'manage_options',
        'aradbranding-shop-wp-settings',
        'aradbranding_shop_wp_render_settings_page'
    );
});

// ثبت منوی اصلی قالب (main-menu)
add_action('after_setup_theme', function () {
    register_nav_menus([
        'main-menu' => __('منوی اصلی', 'aradbranding-shop-wp'),
    ]);
});

// افزودن گزینه‌های لوگوی تنظیمات قالب و رنگ هدر/فوتر
add_action('admin_init', function () {
    add_settings_section('abad_header_section', __('تنظیمات هدر و فوتر', 'aradbranding-shop-wp'), null, 'aradbranding-shop-wp-settings');
    // آپلود لوگو
    add_settings_field('abad_custom_logo', __('آپلود لوگو', 'aradbranding-shop-wp'), function () {
        $logo = get_option('abad_custom_logo', '');
        echo '<input type="text" id="abad_custom_logo" name="abad_custom_logo" value="' . esc_attr($logo) . '" style="width:68%" /> ';
        echo '<button class="button" id="abad_choose_logo">انتخاب/آپلود لوگو</button>';
        if ($logo) {
            echo '<br><img src="' . esc_url($logo) . '" alt="preview" style="max-width:130px;margin-top:8px;vertical-align:middle;border-radius:6px;">';
        }
        ?>
        <script>
        document.addEventListener('DOMContentLoaded', function(){
            var frame;
            document.getElementById('abad_choose_logo').onclick = function(e){
                e.preventDefault();
                if(frame){frame.open();return;}
                frame = wp.media({title:'<?php echo esc_js(__('انتخاب لوگو', 'aradbranding-shop-wp')); ?>', button:{text:'<?php echo esc_js(__('انتخاب', 'aradbranding-shop-wp')); ?>'}, multiple:false});
                frame.on('select', function(){
                    var att = frame.state().get('selection').first().toJSON();
                    document.getElementById('abad_custom_logo').value=att.url;
                });
                frame.open();
            };
        });
        </script>
        <?php
    }, 'aradbranding-shop-wp-settings', 'abad_header_section');
    register_setting('aradbranding-shop-wp-settings', 'abad_custom_logo');

    // تنظیم رنگ هدر و فوتر
    add_settings_field('abad_header_footer_color', __('رنگ هدر و فوتر', 'aradbranding-shop-wp'), function () {
        $color = get_option('abad_header_footer_color', '#2b2b2b');
        echo '<input type="color" name="abad_header_footer_color" value="' . esc_attr($color) . '" />';
    }, 'aradbranding-shop-wp-settings', 'abad_header_section');
    register_setting('aradbranding-shop-wp-settings', 'abad_header_footer_color');

    // افزودن فیلد اندازه فونت و رنگ فونت هدر
    // اندازه فونت هدر
    add_settings_field('abad_header_font_size', __('اندازه فونت هدر (px)', 'aradbranding-shop-wp'), function () {
        $size = get_option('abad_header_font_size', '15');
        echo '<input type="number" name="abad_header_font_size" value="' . esc_attr($size) . '" min="11" max="40" />';
    }, 'aradbranding-shop-wp-settings', 'abad_header_section');
    register_setting('aradbranding-shop-wp-settings', 'abad_header_font_size');
    // رنگ فونت هدر
    add_settings_field('abad_header_font_color', __('رنگ فونت هدر', 'aradbranding-shop-wp'), function () {
        $color = get_option('abad_header_font_color', '#fff');
        echo '<input type="color" name="abad_header_font_color" value="' . esc_attr($color) . '" />';
    }, 'aradbranding-shop-wp-settings', 'abad_header_section');
    register_setting('aradbranding-shop-wp-settings', 'abad_header_font_color');

    // افزودن رنگ hover و active برای منوی هدر
    // رنگ hover
    add_settings_field('abad_header_menu_hover_color', __('رنگ هاور منو', 'aradbranding-shop-wp'), function () {
        $color = get_option('abad_header_menu_hover_color', '#383838');
        echo '<input type="color" name="abad_header_menu_hover_color" value="' . esc_attr($color) . '" />';
    }, 'aradbranding-shop-wp-settings', 'abad_header_section');
    register_setting('aradbranding-shop-wp-settings', 'abad_header_menu_hover_color');
    // رنگ active
    add_settings_field('abad_header_menu_active_color', __('رنگ اکتیو منو', 'aradbranding-shop-wp'), function () {
        $color = get_option('abad_header_menu_active_color', '#ffd062');
        echo '<input type="color" name="abad_header_menu_active_color" value="' . esc_attr($color) . '" />';
    }, 'aradbranding-shop-wp-settings', 'abad_header_section');
    register_setting('aradbranding-shop-wp-settings', 'abad_header_menu_active_color');
    // رنگ پس‌زمینه اکتیو منو
    add_settings_field('abad_header_menu_active_bg_color', __('رنگ بک‌گراند اکتیو منو', 'aradbranding-shop-wp'), function () {
        $color = get_option('abad_header_menu_active_bg_color', get_option('abad_header_menu_hover_color', '#383838'));
        echo '<input type="color" name="abad_header_menu_active_bg_color" value="' . esc_attr($color) . '" />';
    }, 'aradbranding-shop-wp-settings', 'abad_header_section');
    register_setting('aradbranding-shop-wp-settings', 'abad_header_menu_active_bg_color');
});

// تنظیمات فوتر: لوگو، اطلاعات تماس، دسترسی سریع، کپی‌رایت
add_action('admin_init', function () {
    // بخش فوتر – لوگو
    add_settings_section('abad_footer_section', __('تنظیمات فوتر', 'aradbranding-shop-wp'), null, 'aradbranding-shop-wp-footer-settings');

    // لوگوی فوتر
    add_settings_field('abad_footer_logo', __('آپلود لوگوی فوتر', 'aradbranding-shop-wp'), function () {
        $logo = get_option('abad_footer_logo', '');
        echo '<input type="text" id="abad_footer_logo" name="abad_footer_logo" value="' . esc_attr($logo) . '" style="width:65%" /> ';
        echo '<button class="button" id="abad_choose_footer_logo">انتخاب/آپلود لوگو</button>';
        if ($logo) {
            echo '<br><img src="' . esc_url($logo) . '" alt="preview" style="max-width:130px;margin-top:8px;vertical-align:middle;border-radius:6px;">';
        }
        ?>
        <script>
        document.addEventListener('DOMContentLoaded', function(){
            var frame;
            document.getElementById('abad_choose_footer_logo').onclick = function(e){
                e.preventDefault();
                if(frame){frame.open();return;}
                frame = wp.media({title:'<?php echo esc_js(__('انتخاب لوگو', 'aradbranding-shop-wp')); ?>', button:{text:'<?php echo esc_js(__('انتخاب', 'aradbranding-shop-wp')); ?>'}, multiple:false});
                frame.on('select', function(){
                    var att = frame.state().get('selection').first().toJSON();
                    document.getElementById('abad_footer_logo').value = att.url;
                });
                frame.open();
            };
        });
        </script>
        <?php
    }, 'aradbranding-shop-wp-footer-settings', 'abad_footer_section');
    register_setting('aradbranding-shop-wp-footer-settings', 'abad_footer_logo');

    // متن تماس فوتر
    add_settings_field('abad_footer_contact', __('متن تماس/آدرس', 'aradbranding-shop-wp'), function () {
        $val = get_option('abad_footer_contact', "آدرس: تهران، سعادت‌آباد، برج آراد\nتلفن: 021-00000\nایمیل: info@aradbranding.com");
        echo '<textarea name="abad_footer_contact" rows="4" style="width:88%;font-family:Vazir,Tahoma">'.esc_textarea($val).'</textarea>';
    }, 'aradbranding-shop-wp-footer-settings', 'abad_footer_section');
    register_setting('aradbranding-shop-wp-footer-settings', 'abad_footer_contact');

    // لینک‌های دسترسی سریع فوتر (آرایه سریالی)
    add_settings_field('abad_footer_quicklinks', __('لینک‌های دسترسی سریع', 'aradbranding-shop-wp'), function () {
        $links = get_option('abad_footer_quicklinks', []);
        if(!is_array($links)){ $links = []; }
        echo '<div id="abad_quicklinks_wrap">';
        if (!$links) $links=[['','']];
        foreach($links as $i=>$row) {
            echo '<div style="margin-bottom:7px"><input type="text" name="abad_footer_quicklinks['.$i.'][0]" value="'.esc_attr($row[0]).'" placeholder="عنوان لینک" style="width:29%"> ';
            echo '<input type="text" name="abad_footer_quicklinks['.$i.'][1]" value="'.esc_attr($row[1]).'" placeholder="آدرس http یا /page" style="width:36%"> ';
            echo '<button type="button" onclick="this.parentNode.remove();">حذف</button></div>';
        }
        echo '</div>';
        echo '<button type="button" onclick="addQuickLinkRow()">افزودن لینک جدید</button>';
        ?>
        <script>
        function addQuickLinkRow(){
            var wrap=document.getElementById('abad_quicklinks_wrap');
            var i=wrap.children.length;
            wrap.insertAdjacentHTML('beforeend', '<div style="margin-bottom:7px"><input type="text" name="abad_footer_quicklinks['+i+'][0]" placeholder="عنوان لینک" style="width:29%"> <input type="text" name="abad_footer_quicklinks['+i+'][1]" placeholder="آدرس http یا /page" style="width:36%"> <button type="button" onclick="this.parentNode.remove();">حذف</button></div>');
        }
        </script>
        <?php
    }, 'aradbranding-shop-wp-footer-settings', 'abad_footer_section');
    register_setting('aradbranding-shop-wp-footer-settings', 'abad_footer_quicklinks');

    // متن پایانی فوتر (کپی‌رایت و ...)
    add_settings_field('abad_footer_copyright', __('متن کپی‌رایت فوتر', 'aradbranding-shop-wp'), function () {
        $val = get_option('abad_footer_copyright', '© '.date('Y').' - تمامی حقوق متعلق به آرادبرندینگ است.');
        echo '<input name="abad_footer_copyright" type="text" value="'.esc_attr($val).'" style="width:80%"/>';
    }, 'aradbranding-shop-wp-footer-settings', 'abad_footer_section');
    register_setting('aradbranding-shop-wp-footer-settings', 'abad_footer_copyright');
});

// تنظیمات صفحه اصلی: کارت محصولات
add_action('admin_init', function () {
    add_settings_section('abad_homepage_section', __('تنظیمات صفحه اصلی', 'aradbranding-shop-wp'), null, 'aradbranding-shop-wp-homepage-settings');

    // تنظیمات کارت محصولات
    add_settings_field('abad_product_card_bg', __('رنگ بک‌گراند کارت محصول', 'aradbranding-shop-wp'), function () {
        $color = get_option('abad_product_card_bg', '#ffffff');
        echo '<input type="color" name="abad_product_card_bg" value="' . esc_attr($color) . '" />';
    }, 'aradbranding-shop-wp-homepage-settings', 'abad_homepage_section');
    register_setting('aradbranding-shop-wp-homepage-settings', 'abad_product_card_bg');

    add_settings_field('abad_product_price_color', __('رنگ قیمت محصول', 'aradbranding-shop-wp'), function () {
        $color = get_option('abad_product_price_color', '#b3006d');
        echo '<input type="color" name="abad_product_price_color" value="' . esc_attr($color) . '" />';
    }, 'aradbranding-shop-wp-homepage-settings', 'abad_homepage_section');
    register_setting('aradbranding-shop-wp-homepage-settings', 'abad_product_price_color');

    add_settings_field('abad_product_btn_bg', __('رنگ بک‌گراند دکمه محصول', 'aradbranding-shop-wp'), function () {
        $color = get_option('abad_product_btn_bg', '#ffd062');
        echo '<input type="color" name="abad_product_btn_bg" value="' . esc_attr($color) . '" />';
    }, 'aradbranding-shop-wp-homepage-settings', 'abad_homepage_section');
    register_setting('aradbranding-shop-wp-homepage-settings', 'abad_product_btn_bg');

    add_settings_field('abad_product_btn_text', __('رنگ متن دکمه محصول', 'aradbranding-shop-wp'), function () {
        $color = get_option('abad_product_btn_text', '#111111');
        echo '<input type="color" name="abad_product_btn_text" value="' . esc_attr($color) . '" />';
    }, 'aradbranding-shop-wp-homepage-settings', 'abad_homepage_section');
    register_setting('aradbranding-shop-wp-homepage-settings', 'abad_product_btn_text');
});

// تنظیمات تماس با ما
add_action('admin_init', function () {
    add_settings_section('abad_contact_section', __('تنظیمات تماس با ما', 'aradbranding-shop-wp'), null, 'aradbranding-shop-wp-contact-settings');
    $ch = 'checked disabled';
    // پیکربندی روش‌های تماس (ایمیل، تلفن، واتساپ، تلگرام، اینستاگرام)
    $fields = [
      ['email','ایمیل'], ['mobile','شماره تلفن'], ['whatsapp','واتساپ'], ['telegram','تلگرام'], ['instagram','اینستاگرام']
    ];
    foreach($fields as [$key,$label]) {
        add_settings_field("contact_{$key}_enable", sprintf('فعال‌سازی %s', $label), function() use ($key) {
            $enabled = get_option("contact_{$key}_enable", '1');
            echo '<input type="checkbox" name="contact_' . $key . '_enable" value="1" '.($enabled ? 'checked' : '').' />';
        }, 'aradbranding-shop-wp-contact-settings', 'abad_contact_section');
        add_settings_field("contact_{$key}_link", sprintf('آدرس/شماره/لینک %s', $label), function() use ($key) {
            $val = get_option("contact_{$key}_link", '');
            $plc = 'لینک یا شماره';
            if($key==='email') $plc = 'ایمیل مثال: info@example.com';
            if($key==='mobile') $plc = 'شماره مثل 02112345678';
            if($key==='whatsapp') $plc = 'https://wa.me/98xxxxxxxxxx';
            if($key==='telegram') $plc = 'https://t.me/yourid';
            if($key==='instagram') $plc = 'https://instagram.com/yourid';
            echo '<input type="text" name="contact_' . $key . '_link" value="' . esc_attr($val) . '" style="width:60%" placeholder="'.$plc.'">';
        }, 'aradbranding-shop-wp-contact-settings', 'abad_contact_section');
        register_setting('aradbranding-shop-wp-contact-settings', "contact_{$key}_enable");
        register_setting('aradbranding-shop-wp-contact-settings', "contact_{$key}_link");
    }
    // تنظیمات رنگ دکمه فرم تماس
    add_settings_field('contact_btn_bg', __('رنگ دکمه فرم تماس', 'aradbranding-shop-wp'), function () {
        $color = get_option('contact_btn_bg', '#faaf40');
        echo '<input type="text" name="contact_btn_bg" value="' . esc_attr($color) . '" class="color-picker" data-default-color="#faaf40" />';
    }, 'aradbranding-shop-wp-contact-settings', 'abad_contact_section');
    register_setting('aradbranding-shop-wp-contact-settings', 'contact_btn_bg');
    add_settings_field('contact_btn_hover', __('رنگ هاور دکمه فرم تماس', 'aradbranding-shop-wp'), function () {
        $color = get_option('contact_btn_hover', '#fbb81a');
        echo '<input type="text" name="contact_btn_hover" value="' . esc_attr($color) . '" class="color-picker" data-default-color="#fbb81a" />';
    }, 'aradbranding-shop-wp-contact-settings', 'abad_contact_section');
    register_setting('aradbranding-shop-wp-contact-settings', 'contact_btn_hover');
    add_settings_field('contact_btn_text', __('رنگ متن دکمه فرم تماس', 'aradbranding-shop-wp'), function () {
        $color = get_option('contact_btn_text', '#ffffff');
        echo '<input type="text" name="contact_btn_text" value="' . esc_attr($color) . '" class="color-picker" data-default-color="#ffffff" />';
    }, 'aradbranding-shop-wp-contact-settings', 'abad_contact_section');
    register_setting('aradbranding-shop-wp-contact-settings', 'contact_btn_text');
    
    // اضافه کردن اسکریپت Color Picker
    add_action('admin_footer', function() {
        if (isset($_GET['page']) && $_GET['page'] === 'aradbranding-shop-wp-settings') {
            ?>
            <script>
            jQuery(document).ready(function($) {
                $('.color-picker').wpColorPicker();
            });
            </script>
            <?php
        }
    });
});

// نمایش فرم تنظیمات فوتر در تب جداگانه صفحه تنظیمات قالب
add_action('admin_menu', function () {
    add_submenu_page( null, __('تنظیمات فوتر', 'aradbranding-shop-wp'), __('تنظیمات فوتر', 'aradbranding-shop-wp'), 'manage_options', 'aradbranding-shop-wp-footer-settings', function() {
        echo '<div class="wrap"><h1>تنظیمات فوتر</h1>';
        echo '<form method="post" action="options.php">';
        settings_fields('aradbranding-shop-wp-footer-settings');
        do_settings_sections('aradbranding-shop-wp-footer-settings');
        submit_button('ذخیره فوتر');
        echo '</form></div>';
    });
});

// بارگذاری اسکریپت رسانه وردپرس برای uploader لوگو فقط هنگام مشاهده تب هدر تنظیمات قالب
add_action('admin_enqueue_scripts', function ($hook) {
    if (
        $hook === 'appearance_page_aradbranding-shop-wp-settings' &&
        !empty($_GET['tab']) && $_GET['tab'] === 'header'
    ) {
        wp_enqueue_media();
    }
    // بارگذاری رسانه برای صفحه ویرایش محصولات (گالری چندتایی)
    if ($hook === 'post.php' || $hook === 'post-new.php') {
        global $post_type;
        if ($post_type === 'abad_product') {
            wp_enqueue_media();
        }
    }
});

// رفع خطای wp.media در آپلود لوگو فوتر (همان سبک هدر)
add_action('admin_enqueue_scripts', function ($hook) {
    if (
        $hook === 'appearance_page_aradbranding-shop-wp-settings' &&
        !empty($_GET['tab']) && $_GET['tab'] === 'footer'
    ) {
        wp_enqueue_media();
    }
});

// نمایش فرم ذخیره تغییرات در تب هدر و فوتر تنظیمات
function aradbranding_shop_wp_render_settings_page() {
    $current_tab = $_GET['tab'] ?? 'general';
    echo '<div class="wrap abad-theme-settings" style="direction:rtl;max-width:1100px;min-height:680px;">';
    // استایل سراسری رنگ‌بندی
    echo '<style>:root{ --color-primary: #a5525f; --color-secondary: #d4af37; --color-accent: #2b2b2b; --color-heading: #0f0f0f; --color-body: #232323; --color-meta: #757575; --color-bg: #f5f5f5; --color-primary-hover: #9d5563; --color-secondary-hover: #a98a27; --border-radius: 1rem; }
.abad-theme-settings-tabs .nav-tab {
  background: #fff!important; color: var(--color-primary)!important; font-weight: 700;margin-left:4px;
  border-radius: calc(var(--border-radius)/1.5) calc(var(--border-radius)/1.5) 0 0!important;
  border: 2px solid var(--color-primary)!important;border-bottom: none!important;transition: .13s;}
.abad-theme-settings-tabs .nav-tab-active {
  background: var(--color-primary)!important; color: #fff!important; border-bottom: none!important;}
.form-table th {color: var(--color-heading); font-weight:700;}
.form-table td input[type=text],
.form-table td input[type=email],
.form-table td input[type=number],
.form-table td textarea {
  border-radius: calc(var(--border-radius)/2);
  border: 1px solid var(--color-meta);
  padding: 7px 11px;
  background: #fff;
  font-family: Vazir,Tahoma,Arial,sans-serif;
  font-size: 1.06em; color:var(--color-body); }
.abad-theme-settings .submit input[type=submit],
.abad-btn-admin, .abad-theme-settings [type=button] {
  background: var(--color-primary)!important; color: #fff!important;
  font-weight: 700; border-radius: calc(var(--border-radius)/1.8); border: none!important; font-size:1.08em; padding: 8px 30px; margin-top:10px; box-shadow:0 2px 8px #86364b20; transition:background 0.14s;}
.abad-theme-settings .submit input[type=submit]:hover,
.abad-btn-admin:hover,
.abad-theme-settings [type=button]:hover {
  background:var(--color-primary-hover)!important;}
.abad-theme-settings-section {
  background:#fff;border-radius:var(--border-radius);padding:29px 19px 25px 19px;box-shadow:0 2px 17px #e6ccd857;margin-bottom:33px;}
.abad-theme-settings .form-table{background:transparent;}
.abad-theme-settings input[type=checkbox] {accent-color: var(--color-secondary);}
.abad-theme-settings{background:var(--color-bg)!important; padding:18px 7px 68px 7px;border-radius:var(--border-radius);font-family:Vazir,Tahoma,sans-serif;}
</style>';
    echo '<div class="wrap"><h1>' . esc_html__('تنظیمات قالب آرادبرندینگ', 'aradbranding-shop-wp') . '</h1>';
    echo '<nav class="nav-tab-wrapper abad-theme-settings-tabs">';
    $tabs = [
        'general' => __('تنظیمات عمومی', 'aradbranding-shop-wp'),
        'header'  => __('هدر', 'aradbranding-shop-wp'),
        'footer'  => __('فوتر', 'aradbranding-shop-wp'),
        'homepage' => __('صفحه اصلی', 'aradbranding-shop-wp'),
        'blog'    => __('صفحه بلاگ', 'aradbranding-shop-wp'),
        'post' => __('نوشته‌ها', 'aradbranding-shop-wp'),
        'shop'    => __('فروشگاه', 'aradbranding-shop-wp'),
        'contact' => __('تماس با ما', 'aradbranding-shop-wp'),
        'about'   => __('درباره ما', 'aradbranding-shop-wp'),
        'custom'  => __('سفارشی', 'aradbranding-shop-wp'),
    ];
    foreach ($tabs as $tab => $label) {
        $class = ($tab == $current_tab) ? 'nav-tab nav-tab-active' : 'nav-tab';
        echo '<a href="?page=aradbranding-shop-wp-settings&tab=' . $tab . '" class="' . $class . '">' . $label . '</a>';
    }
    echo '</nav>';
    echo '<div class="abad-theme-settings-section" style="min-height:200px;">';
    if ($current_tab === 'header') {
        echo '<form method="post" action="options.php">';
        settings_fields('aradbranding-shop-wp-settings');
        do_settings_sections('aradbranding-shop-wp-settings');
        submit_button(__('ذخیره تغییرات', 'aradbranding-shop-wp'));
        echo '</form>';
    }
    elseif ($current_tab === 'footer') {
        echo '<form method="post" action="options.php">';
        settings_fields('aradbranding-shop-wp-footer-settings');
        do_settings_sections('aradbranding-shop-wp-footer-settings');
        submit_button(__('ذخیره تنظیمات فوتر', 'aradbranding-shop-wp'));
        echo '</form>';
    }
    elseif ($current_tab === 'homepage') {
        echo '<form method="post" action="options.php">';
        settings_fields('aradbranding-shop-wp-homepage-settings');
        do_settings_sections('aradbranding-shop-wp-homepage-settings');
        submit_button(__('ذخیره تنظیمات صفحه اصلی', 'aradbranding-shop-wp'));
        echo '</form>';
    }
    elseif ($current_tab === 'shop') {
        echo '<form method="post" action="options.php">';
        settings_fields('aradbranding-shop-wp-shop-settings');
        do_settings_sections('aradbranding-shop-wp-shop-settings');
        submit_button(__('ذخیره تنظیمات فروشگاه', 'aradbranding-shop-wp'));
        echo '</form>';
    }
    elseif ($current_tab === 'contact') {
        echo '<form method="post" action="options.php">';
        settings_fields('aradbranding-shop-wp-contact-settings');
        do_settings_sections('aradbranding-shop-wp-contact-settings');
        submit_button(__('ذخیره تنظیمات تماس', 'aradbranding-shop-wp'));
        echo '</form>';
    }
    elseif ($current_tab === 'about') {
        echo '<form method="post" action="options.php">';
        settings_fields('aradbranding-shop-wp-about-settings');
        do_settings_sections('aradbranding-shop-wp-about-settings');
        submit_button(__('ذخیره درباره ما', 'aradbranding-shop-wp'));
        echo '</form>';
    }
    elseif ($current_tab === 'custom') {
        echo '<form method="post" action="options.php">';
        settings_fields('aradbranding-shop-wp-custom-settings');
        do_settings_sections('aradbranding-shop-wp-custom-settings');
        submit_button(__('ذخیره تنظیمات سفارشی', 'aradbranding-shop-wp'));
        echo '</form>';
    }
    elseif ($current_tab === 'blog') {
        echo '<form method="post" action="options.php">';
        settings_fields('aradbranding-shop-wp-blog-settings');
        do_settings_sections('aradbranding-shop-wp-blog-settings');
        submit_button(__('ذخیره تنظیمات بلاگ', 'aradbranding-shop-wp'));
        echo '</form>';
    }
    elseif ($current_tab === 'post') {
        echo '<form method="post" action="options.php">';
        settings_fields('aradbranding-shop-wp-post-settings');
        do_settings_sections('aradbranding-shop-wp-post-settings');
        submit_button(__('ذخیره تنظیمات نوشته','aradbranding-shop-wp'));
        echo '</form>';
    }
    else { // عمومی
        echo '<form method="post" action="options.php">';
        settings_fields('aradbranding-shop-wp-general-settings');
        do_settings_sections('aradbranding-shop-wp-general-settings');
        submit_button(__('ذخیره تنظیمات عمومی', 'aradbranding-shop-wp'));
        echo '</form>';
    }
    echo '</div></div>';
}

// ثبت پست تایپ محصولات با اطمینان از پشتیبانی thumbnail (عکس شاخص)
add_action('init', function () {
    register_post_type('abad_product', [
        'labels' => [
            'name' => 'محصولات',
            'singular_name' => 'محصول',
            'add_new' => 'افزودن محصول جدید',
            'add_new_item' => 'افزودن محصول جدید',
            'edit_item' => 'ویرایش محصول',
            'new_item' => 'محصول جدید',
            'view_item' => 'مشاهده محصول',
            'search_items' => 'جستجوی محصولات',
            'not_found' => 'محصولی یافت نشد',
            'all_items' => 'همه محصولات',
        ],
        'public' => true,
        'menu_icon' => 'dashicons-cart',
        'supports' => ['title', 'editor', 'thumbnail'],
        'has_archive' => true,
        'rewrite' => ['slug' => 'products'],
        'show_in_rest' => true,
    ]);
});

// افزودن دسته‌بندی و برچسب به محصولات
add_action('init', function () {
    // طبقه‌بندی (Category)
    register_taxonomy('abad_product_cat', ['abad_product'], [
        'labels' => [
            'name'                  => 'دسته‌بندی محصولات',
            'singular_name'         => 'دسته‌بندی محصول',
            'search_items'          => 'جستجوی دسته',
            'all_items'             => 'همه دسته‌ها',
            'edit_item'             => 'ویرایش دسته',
            'update_item'           => 'بروزرسانی دسته',
            'add_new_item'          => 'افزودن دسته جدید',
            'new_item_name'         => 'نام دسته جدید',
        ],
        'hierarchical' => true,
        'show_admin_column' => true,
        'show_ui' => true,
        'show_in_rest'=> true,
        'rewrite'    => ['slug'=>'product-category'],
    ]);
    // برچسب (Tag)
    register_taxonomy('abad_product_tag', ['abad_product'], [
        'labels' => [ 'name' => 'برچسب محصولات', 'singular_name'=>'برچسب' ],
        'hierarchical' => false,
        'show_admin_column' => true,
        'show_ui' => true,
        'show_in_rest'=> true,
        'rewrite'    => ['slug'=>'product-tag'],
    ]);
});

// اطمینان از اضافه شدن متاباکس تصویر شاخص به صفحه محصولات
add_action('add_meta_boxes', function(){
    if(post_type_exists('abad_product') && post_type_supports('abad_product','thumbnail')){
        add_meta_box( 'postimagediv', __('عکس شاخص','aradbranding-shop-wp'), 'post_thumbnail_meta_box', 'abad_product', 'side', 'low' );
    }
});

// افزودن متاباکس‌ها برای جزییات محصول
add_action('add_meta_boxes', function () {
    add_meta_box('abad_product_details', 'مشخصات محصول', 'abad_product_details_box', 'abad_product', 'normal', 'high');
}, 11);

function abad_product_details_box($post) {
    $price_type = get_post_meta($post->ID, '_abad_price_type', true) ?: 'fixed';
    $price = get_post_meta($post->ID, '_abad_price', true);
    $price_from = get_post_meta($post->ID, '_abad_price_from', true);
    $price_to = get_post_meta($post->ID, '_abad_price_to', true);
    $size = get_post_meta($post->ID, '_abad_size', true);
    $pack = get_post_meta($post->ID, '_abad_pack', true);
    $deliver = get_post_meta($post->ID, '_abad_deliver', true);
    $pay = get_post_meta($post->ID, '_abad_pay', true);
    $table = get_post_meta($post->ID, '_abad_price_table', true);
    $gallery = get_post_meta($post->ID, '_abad_gallery', true);
    if (!is_array($gallery)) $gallery = [];
    wp_nonce_field('abad_save_details', 'abad_details_nonce');
    ?>
    <style>
    .abad-row-flex { display: flex; gap: 13px; margin-bottom: 9px; flex-wrap: wrap; }
    .abad-row-flex > .abad-field { margin-bottom: 0; min-width: 180px; max-width: 220px; }
    .abad-fields { display: flex; flex-direction: column; gap: 6px; margin-bottom: 10px; }
    .abad-field {display: flex; flex-direction: column; margin-bottom: 0; }
    .abad-field label {font-weight:bold;margin-bottom:2px;}
    .abad-field input[type="text"],.abad-field input[type="number"] {
        padding:5.7px 7px;border:1px solid #d4d4d4;border-radius:7px;font-size:15px; margin-bottom: 0; height:36px; line-height:31px;
    }
    .abad-price-type select {height:36px;}
    .abad-table {width:100%;border-collapse:collapse;margin:5px 0 10px 0} .abad-table td,.abad-table th{border:1px solid #bbb;padding:4.5px 7px;text-align:right} .abad-table th{background:#f1f1f1}
    .abad-gallery {display:flex;flex-wrap:wrap;gap:4px;margin:2px 0;} .abad-gallery img{height:55px;object-fit:cover;border-radius:5px;}
    @media(max-width:700px){.abad-row-flex{flex-direction:column;gap:5px;}.abad-field{flex-basis:auto;max-width:100%;}}
    </style>
    <div class="abad-row-flex">
      <div class="abad-field abad-price-type">
        <label>نوع قیمت:</label>
        <select name="abad_price_type" id="abad_price_type" onchange="switchPriceType()">
          <option value="fixed"<?= $price_type=='fixed'?' selected':'' ?>>قیمت ثابت</option>
          <option value="range"<?= $price_type=='range'?' selected':'' ?>>بازه‌ای</option>
          <option value="tavafoghi"<?= $price_type=='tavafoghi'?' selected':'' ?>>توافقی</option>
        </select>
      </div>
      <div class="abad-field" id="price_fixed_field"><label>قیمت</label><input type="number" name="abad_price" value="<?= esc_attr($price) ?>" placeholder="مثلاً ۶۵۰۰۰۰"> <span style="color:#aaa;font-size:13px;">تومان</span></div>
      <div class="abad-field" id="price_range_field_from"><label>حداقل قیمت</label><input type="number" name="abad_price_from" value="<?= esc_attr($price_from) ?>" placeholder="مثلاً ۳۰۰۰۰"> <span style="color:#aaa;font-size:13px;">تومان</span></div>
      <div class="abad-field" id="price_range_field_to"><label>حداکثر قیمت</label><input type="number" name="abad_price_to" value="<?= esc_attr($price_to) ?>" placeholder="مثلاً ۵۰۰۰۰"> <span style="color:#aaa;font-size:13px;">تومان</span></div>
      <div class="abad-field" id="price_tavafoghi_field"><label>قیمت</label><input type="text" value="توافقی" disabled style="background: #e8e8e8;" /></div>
    </div>
    <script>
      function switchPriceType() {
        var val = document.getElementById('abad_price_type').value;
        document.getElementById('price_fixed_field').style.display = (val==="fixed")?"flex":"none";
        document.getElementById('price_range_field_from').style.display = (val==="range")?"flex":"none";
        document.getElementById('price_range_field_to').style.display = (val==="range")?"flex":"none";
        document.getElementById('price_tavafoghi_field').style.display = (val==="tavafoghi")?"flex":"none";
      }
      switchPriceType();
    </script>
    <div class="abad-fields">
        <div class="abad-field"><label>اندازه</label><input type="text" name="abad_size" value="<?= esc_attr($size) ?>" placeholder="مثلاً 32 میلی‌متر"></div>
        <div class="abad-field"><label>نوع بسته‌بندی</label><input type="text" name="abad_pack" value="<?= esc_attr($pack) ?>" placeholder="مثلاً شیرینگ"></div>
        <div class="abad-field"><label>تحویل</label><input type="text" name="abad_deliver" value="<?= esc_attr($deliver) ?>" placeholder="مثلاً فوری"></div>
        <div class="abad-field"><label>پرداخت</label><input type="text" name="abad_pay" value="<?= esc_attr($pay) ?>" placeholder="مثلاً نقدی"></div>
    </div>
    <div style="margin-bottom: 15px;">
      <label style="display:block;font-weight:bold;margin-bottom:7px;">جدول قیمت:</label>
      <table class="abad-table"><thead><tr><th>شرایط سفارش</th><th>قیمت</th></tr></thead><tbody id="abad-price-rows">
      <?php
      if (!empty($table) && is_array($table)) {
          foreach ($table as $row) {
              echo '<tr><td><input type="text" name="abad_table_cond[]" value="'.esc_attr($row[0]).'" /></td>';
              echo '<td><input type="text" name="abad_table_price[]" value="'.esc_attr($row[1]).'" /></td></tr>';
          }
      } else {
          echo '<tr><td><input type="text" name="abad_table_cond[]" /></td><td><input type="text" name="abad_table_price[]" /></td></tr>';
      }
      ?>
      </tbody></table>
      <button type="button" onclick="addPriceRow()">افزودن ردیف</button>
      <script>function addPriceRow(){document.getElementById('abad-price-rows').insertAdjacentHTML('beforeend','<tr><td><input type=\'text\' name=\'abad_table_cond[]\'/></td><td><input type=\'text\' name=\'abad_table_price[]\'/></td></tr>');}</script>
    </div>
    <div style="margin-bottom: 12px;">
      <label style="font-weight:bold;display:block;">تصاویر محصول (گالری چندتایی):</label>
      <div class="abad-gallery">
      <?php foreach($gallery as $img){echo '<img src="'.esc_attr($img).'"/>';} ?>
      </div>
      <input type="hidden" name="abad_product_gallery" id="abad_product_gallery" value="<?= esc_attr(implode(',',$gallery)) ?>" />
      <button type="button" id="abad_upload_gallery" class="button">انتخاب یا آپلود تصاویر</button>
      <script>
      document.addEventListener('DOMContentLoaded', function(){
        document.getElementById('abad_upload_gallery').onclick=function(e){
          e.preventDefault();
          var frame = wp.media({
            title: 'انتخاب چند تصویر برای گالری محصول',
            multiple: true,
            library: {type: 'image'},
            button: {text: 'افزودن تصاویر انتخاب شده'}
          });
          frame.on('select',function(){
            var selection = frame.state().get('selection');
            var urls = selection.toArray().map(function(attachment){
              return attachment.attributes.url;
            });
            document.getElementById('abad_product_gallery').value = urls.join(',');
            // نمایش پیش‌نمایش تصاویر انتخاب شده
            var galleryDiv = document.querySelector('.abad-gallery');
            galleryDiv.innerHTML = '';
            urls.forEach(function(url){
              galleryDiv.innerHTML += '<img src="'+url+'" style="height:55px;object-fit:cover;border-radius:5px;margin:2px;"/>';
            });
          });
          frame.open();
        };
      });
      </script>
    </div>
    <?php
}

add_action('save_post_abad_product', function($post_id){
    if (!isset($_POST['abad_details_nonce']) || !wp_verify_nonce($_POST['abad_details_nonce'],'abad_save_details')) return;
    update_post_meta($post_id,'_abad_price_type',sanitize_text_field($_POST['abad_price_type'] ?? 'fixed'));
    update_post_meta($post_id,'_abad_price',sanitize_text_field($_POST['abad_price'] ?? ''));
    update_post_meta($post_id,'_abad_price_from',sanitize_text_field($_POST['abad_price_from'] ?? ''));
    update_post_meta($post_id,'_abad_price_to',sanitize_text_field($_POST['abad_price_to'] ?? ''));
    update_post_meta($post_id,'_abad_size',sanitize_text_field($_POST['abad_size'] ?? ''));
    update_post_meta($post_id,'_abad_pack',sanitize_text_field($_POST['abad_pack'] ?? ''));
    update_post_meta($post_id,'_abad_deliver',sanitize_text_field($_POST['abad_deliver'] ?? ''));
    update_post_meta($post_id,'_abad_pay',sanitize_text_field($_POST['abad_pay'] ?? ''));
    // جدول قیمت
    $table=[];$conds=$_POST['abad_table_cond']??[];$prices=$_POST['abad_table_price']??[];
    for($i=0;$i<count($conds);$i++){if(trim($conds[$i])||trim($prices[$i]))$table[]=array($conds[$i],$prices[$i]);}
    update_post_meta($post_id,'_abad_price_table',$table);
    //گالری
    $gallery=explode(',',sanitize_text_field($_POST['abad_product_gallery'] ?? ''));
    $gallery=array_filter($gallery); update_post_meta($post_id,'_abad_gallery',$gallery);
});

// ثبت پیام فرم تماس با ما در دیتابیس (custom table یا wp_options سریالی)
add_action('wp_ajax_nopriv_abad_save_contact_form', 'abad_save_contact_form');
add_action('wp_ajax_abad_save_contact_form', 'abad_save_contact_form');
function abad_save_contact_form() {
    // کپچا
    $op = $_POST['cf_captcha_op'] ?? '';
    $a = intval($_POST['cf_captcha_a'] ?? 0);
    $b = intval($_POST['cf_captcha_b'] ?? 0);
    $user_ans = intval($_POST['cf_captcha_user'] ?? 0);
    switch($op){
        case '+': $right = $a + $b; break;
        case '*': $right = $a * $b; break;
        default: $right = null;
    }
    if($right === null || $user_ans !== $right){
        wp_send_json_error(['message'=>'کد امنیتی اشتباه است.', 'captcha_error' => true]);
        exit;
    }
    $name = sanitize_text_field($_POST['name'] ?? '');
    $email = sanitize_email($_POST['email'] ?? '');
    $message = sanitize_textarea_field($_POST['message'] ?? '');
    $data = compact('name','email','message');
    $all = get_option('abad_contact_submissions', []);
    if(!is_array($all)) $all = [];
    $all[] = [
        'name'=>$name,
        'email'=>$email,
        'message'=>$message,
        'date'=> current_time('Y-m-d H:i'),
        'ip'=> $_SERVER['REMOTE_ADDR'] ?? ''
    ];
    update_option('abad_contact_submissions', $all);
    wp_send_json_success(['ok'=>1]);
}
// منوی مدیریت پیام‌های تماس
add_action('admin_menu', function(){
    add_menu_page('پیام‌های تماس','پیام‌های تماس','manage_options','abad-contact-messages','abad_contact_admin_page','dashicons-email-alt2');
});
add_action('wp_ajax_abad_delete_contact_message', function(){
  if(!current_user_can('manage_options') || !isset($_POST['idx'])) wp_send_json_error(['message'=>'عدم دسترسی']);
  $idx = intval($_POST['idx']);
  $msgs = get_option('abad_contact_submissions', []);
  if(!is_array($msgs) || !isset($msgs[$idx])) wp_send_json_error(['message'=>'یافت نشد']);
  array_splice($msgs, $idx, 1);
  update_option('abad_contact_submissions', $msgs);
  wp_send_json_success(['ok'=>1]);
});
function abad_contact_admin_page() {
    if (!current_user_can('manage_options')) return;
    $msgs = get_option('abad_contact_submissions', []);
    $total_count = count($msgs);
    ?>
    <div class="wrap abad-contact-messages-page" style="direction:rtl;font-family:Vazir,Tahoma,Arial,sans-serif;">
        <style>
        .abad-contact-messages-page h1 {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 20px 30px;
            border-radius: 12px;
            margin: 20px 0;
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
            font-size: 24px;
            font-weight: 800;
            display: flex;
            align-items: center;
            gap: 15px;
        }
        .abad-stats-cards {
            display: flex;
            gap: 20px;
            margin: 25px 0;
            flex-wrap: wrap;
        }
        .abad-stat-card {
            background: white;
            border-radius: 12px;
            padding: 20px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.08);
            border-right: 4px solid #667eea;
            min-width: 200px;
            flex: 1;
        }
        .abad-stat-number {
            font-size: 32px;
            font-weight: 900;
            color: #667eea;
            margin-bottom: 5px;
        }
        .abad-stat-label {
            color: #666;
            font-size: 14px;
            font-weight: 600;
        }
        .abad-messages-container {
            background: white;
            border-radius: 12px;
            box-shadow: 0 2px 15px rgba(0,0,0,0.08);
            overflow: hidden;
            margin-top: 25px;
        }
        .abad-messages-header {
            background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
            color: white;
            padding: 15px 25px;
            font-weight: 700;
            font-size: 16px;
        }
        .abad-message-card {
            border-bottom: 1px solid #f0f0f0;
            padding: 20px 25px;
            transition: all 0.2s ease;
            position: relative;
        }
        .abad-message-card:hover {
            background: #f8f9ff;
            transform: translateX(-3px);
        }
        .abad-message-card:last-child {
            border-bottom: none;
        }
        .abad-message-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 12px;
        }
        .abad-message-sender {
            display: flex;
            align-items: center;
            gap: 12px;
        }
        .abad-sender-avatar {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: linear-gradient(135deg, #667eea, #764ba2);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: 700;
            font-size: 16px;
        }
        .abad-sender-info h4 {
            margin: 0;
            font-size: 16px;
            color: #333;
            font-weight: 700;
        }
        .abad-sender-info span {
            font-size: 13px;
            color: #666;
        }
        .abad-message-date {
            background: #e3f2fd;
            color: #1976d2;
            padding: 4px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
        }
        .abad-message-content {
            background: #f8f9fa;
            border-radius: 8px;
            padding: 15px;
            margin: 12px 0;
            border-right: 3px solid #667eea;
            line-height: 1.6;
            color: #444;
        }
        .abad-message-actions {
            display: flex;
            justify-content: flex-end;
            gap: 10px;
            margin-top: 15px;
        }
        .abad-btn-delete {
            background: linear-gradient(135deg, #ff6b6b, #ee5a52);
            color: white;
            border: none;
            padding: 8px 20px;
            border-radius: 25px;
            font-size: 13px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.2s ease;
            box-shadow: 0 2px 8px rgba(255, 107, 107, 0.3);
        }
        .abad-btn-delete:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 15px rgba(255, 107, 107, 0.4);
        }
        .abad-btn-delete:disabled {
            opacity: 0.6;
            cursor: not-allowed;
            transform: none;
        }
        .abad-empty-state {
            text-align: center;
            padding: 60px 20px;
            color: #666;
        }
        .abad-empty-icon {
            font-size: 64px;
            color: #ddd;
            margin-bottom: 20px;
        }
        .abad-empty-title {
            font-size: 20px;
            font-weight: 700;
            color: #333;
            margin-bottom: 10px;
        }
        .abad-empty-desc {
            font-size: 14px;
            color: #666;
        }
        </style>
        
        <h1>
            <span style="font-size: 28px;">📧</span>
            پیام‌های تماس با ما
        </h1>
        
        <div class="abad-stats-cards">
            <div class="abad-stat-card">
                <div class="abad-stat-number"><?php echo number_format($total_count); ?></div>
                <div class="abad-stat-label">کل پیام‌های دریافتی</div>
            </div>
        </div>
        
        <div class="abad-messages-container">
            <div class="abad-messages-header">
                📋 لیست پیام‌های دریافتی
            </div>
            <?php if (empty($msgs)): ?>
                <div class="abad-empty-state">
                    <div class="abad-empty-icon">📭</div>
                    <div class="abad-empty-title">هیچ پیامی دریافت نشده</div>
                    <div class="abad-empty-desc">هنوز هیچ پیامی از طریق فرم تماس ارسال نشده است.</div>
                </div>
            <?php else: ?>
                <?php foreach ($msgs as $idx => $msg): ?>
                    <div class="abad-message-card" id="msg-<?php echo $idx; ?>">
                        <div class="abad-message-header">
                            <div class="abad-message-sender">
                                <div class="abad-sender-avatar">
                                    <?php echo strtoupper(substr($msg['name'], 0, 1)); ?>
                                </div>
                                <div class="abad-sender-info">
                                    <h4><?php echo esc_html($msg['name']); ?></h4>
                                    <span><?php echo esc_html($msg['email']); ?></span>
                                </div>
                            </div>
                            <div class="abad-message-date"><?php echo esc_html($msg['date']); ?></div>
                        </div>
                        <div class="abad-message-content">
                            <?php echo nl2br(esc_html($msg['message'])); ?>
                        </div>
                        <div class="abad-message-actions">
                            <button class="abad-btn-delete" onclick="deleteMessage(<?php echo $idx; ?>)">
                                🗑️ حذف پیام
                            </button>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </div>
    
    <script>
    function deleteMessage(idx) {
        if (!confirm('آیا مطمئن هستید که می‌خواهید این پیام را حذف کنید؟')) return;
            
        var btn = event.target;
            btn.disabled = true;
        btn.textContent = 'در حال حذف...';
            
            fetch(ajaxurl, {
                method: 'POST',
                headers: {'Content-Type': 'application/x-www-form-urlencoded'},
                body: 'action=abad_delete_contact_message&idx=' + idx
            })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                document.getElementById('msg-' + idx).remove();
                            location.reload();
                } else {
                alert('خطا در حذف پیام: ' + (data.data?.message || 'خطای نامشخص'));
                    btn.disabled = false;
                btn.textContent = '🗑️ حذف پیام';
                }
            })
        .catch(error => {
            alert('خطا در ارتباط با سرور');
                btn.disabled = false;
            btn.textContent = '🗑️ حذف پیام';
            });
    }
    </script>
    <?php
}

// -- تنظیمات تب بلاگ --
add_action('admin_init', function () {
    add_settings_section('abad_blog_section', __('تنظیمات کارت‌های صفحه بلاگ', 'aradbranding-shop-wp'), function () {
        echo '<p style="margin-bottom:20px;">شخصی‌سازی رنگ‌بندی کارت‌های مقالات بلاگ</p>';
    }, 'aradbranding-shop-wp-blog-settings');

    // رنگ پس زمینه کارت
    add_settings_field('abad_blog_card_bg', __('رنگ پس زمینه کارت', 'aradbranding-shop-wp'), function () {
        $val = get_option('abad_blog_card_bg', '#fff');
        echo "<input type='color' name='abad_blog_card_bg' value='" . esc_attr($val) . "' />";
    }, 'aradbranding-shop-wp-blog-settings', 'abad_blog_section');
    register_setting('aradbranding-shop-wp-blog-settings', 'abad_blog_card_bg');

    // رنگ دکمه ادامه مطلب
    add_settings_field('abad_blog_btn_bg', __('رنگ دکمه ادامه مطلب', 'aradbranding-shop-wp'), function () {
        $val = get_option('abad_blog_btn_bg', '#ffd062');
        echo "<input type='color' name='abad_blog_btn_bg' value='" . esc_attr($val) . "' />";
    }, 'aradbranding-shop-wp-blog-settings', 'abad_blog_section');
    register_setting('aradbranding-shop-wp-blog-settings', 'abad_blog_btn_bg');

    // رنگ تیتر مقاله
    add_settings_field('abad_blog_title_color', __('رنگ تیتر مقاله', 'aradbranding-shop-wp'), function () {
        $val = get_option('abad_blog_title_color', '#822253');
        echo "<input type='color' name='abad_blog_title_color' value='" . esc_attr($val) . "' />";
    }, 'aradbranding-shop-wp-blog-settings', 'abad_blog_section');
    register_setting('aradbranding-shop-wp-blog-settings', 'abad_blog_title_color');

    // رنگ متن معمولی کارت
    add_settings_field('abad_blog_text_color', __('رنگ متن کارت', 'aradbranding-shop-wp'), function () {
        $val = get_option('abad_blog_text_color', '#303030');
        echo "<input type='color' name='abad_blog_text_color' value='" . esc_attr($val) . "' />";
    }, 'aradbranding-shop-wp-blog-settings', 'abad_blog_section');
    register_setting('aradbranding-shop-wp-blog-settings', 'abad_blog_text_color');

    // رنگ خلاصه مطلب
    add_settings_field('abad_blog_excerpt_color', __('رنگ خلاصه مطلب', 'aradbranding-shop-wp'), function () {
        $val = get_option('abad_blog_excerpt_color', '#303030');
        echo "<input type='color' name='abad_blog_excerpt_color' value='" . esc_attr($val) . "' />";
    }, 'aradbranding-shop-wp-blog-settings', 'abad_blog_section');
    register_setting('aradbranding-shop-wp-blog-settings', 'abad_blog_excerpt_color');
});

// ---- افزودن فیلد آپلود Favicon به تنظیمات تب عمومی ----
add_action('admin_init', function () {
    if (!has_filter('abad_general_section_defined')) {
        add_settings_section('abad_general_section', __('عمومی','aradbranding-shop-wp'), function(){}, 'aradbranding-shop-wp-general-settings');
        add_filter('abad_general_section_defined', '__return_true');
    }
    // فیلد Favicon
    add_settings_field('abad_favicon','فاوآیکون (Favicon)',function() {
        $val = get_option('abad_favicon', '');
        echo '<input type="text" id="abad_favicon" name="abad_favicon" value="'.esc_attr($val).'" style="width:66%" /> ';
        echo '<button class="button" id="abad_choose_favicon">انتخاب/آپلود آیکون</button>';
        if($val){
            echo '<br><img src="'.esc_url($val).'" alt="favicon-preview" style="max-width:44px;margin-top:8px;vertical-align:middle;border-radius:6px;">';
        }
        ?>
        <script>document.addEventListener('DOMContentLoaded', function(){
            var btn = document.getElementById('abad_choose_favicon');
            if(btn){
                btn.onclick = function(e){
                    e.preventDefault();
                    if(window._abadFavIcnFrm){window._abadFavIcnFrm.open();return;}
                    window._abadFavIcnFrm = wp.media({title:'انتخاب فاوآیکون', button:{text:'انتخاب'}, multiple:false});
                    window._abadFavIcnFrm.on('select', function(){
                        var att = window._abadFavIcnFrm.state().get('selection').first().toJSON();
                        document.getElementById('abad_favicon').value=att.url;
                    });
                    window._abadFavIcnFrm.open();
                };
            }
        });</script>
        <?php
    }, 'aradbranding-shop-wp-general-settings', 'abad_general_section');
    register_setting('aradbranding-shop-wp-general-settings', 'abad_favicon');
    // تیتر اطلاعات مالک
    add_settings_field('__owner_title',' ',function(): void{echo '<hr><strong style="font-size:15px;color:#a5525f">اطلاعات مالک سایت</strong>';},'aradbranding-shop-wp-general-settings','abad_general_section');
    add_settings_field('abad_owner_name','نام مالک',function(){
        $v=get_option('abad_owner_name','');
        echo '<input type="text" name="abad_owner_name" value="'.esc_attr($v).'" style="width:230px"/>';
    },'aradbranding-shop-wp-general-settings','abad_general_section');
    register_setting('aradbranding-shop-wp-general-settings','abad_owner_name');
    add_settings_field('abad_owner_phone','شماره تماس مالک',function(){
        $v=get_option('abad_owner_phone','');
        echo '<input type="text" name="abad_owner_phone" value="'.esc_attr($v).'" style="width:180px"/>';
    },'aradbranding-shop-wp-general-settings','abad_general_section');
    register_setting('aradbranding-shop-wp-general-settings','abad_owner_phone');
    add_settings_field('abad_owner_avatar','عکس مالک',function(){
        $img=get_option('abad_owner_avatar','');
        echo '<input type="text" id="abad_owner_avatar" name="abad_owner_avatar" value="'.esc_attr($img).'" style="width:55%"/> ';
        echo '<button class="button" id="abad_choose_owner_img">انتخاب/آپلود تصویر</button>';
        if($img) echo '<br><img src="'.esc_url($img).'" alt="own" style="max-width:72px;margin-top:7px;border-radius:10px;box-shadow:0 2px 9px #d4bdae7c;">';
        ?>
        <script>document.addEventListener('DOMContentLoaded',function(){
        var btn=document.getElementById('abad_choose_owner_img');if(btn){btn.onclick=function(e){e.preventDefault();if(window.abdOwnerFrm){window.abdOwnerFrm.open();return;}window.abdOwnerFrm=wp.media({title:'انتخاب تصویر پروفایل',button:{text:'انتخاب'},multiple:false});window.abdOwnerFrm.on('select',function(){var att=window.abdOwnerFrm.state().get('selection').first().toJSON();document.getElementById('abad_owner_avatar').value=att.url;});window.abdOwnerFrm.open();};}}
        );</script><?php
    },'aradbranding-shop-wp-general-settings','abad_general_section');
    register_setting('aradbranding-shop-wp-general-settings','abad_owner_avatar');
    
    // متن دکمه تماس
    add_settings_field('abad_owner_button_text','متن دکمه تماس',function(){
        $v=get_option('abad_owner_button_text','تماس');
        echo '<input type="text" name="abad_owner_button_text" value="'.esc_attr($v).'" style="width:230px" placeholder="تماس"/>';
        echo '<p style="color:#666;font-size:12px;">متن دکمه تماس در صفحه محصول (پیش‌فرض: تماس)</p>';
    },'aradbranding-shop-wp-general-settings','abad_general_section');
    register_setting('aradbranding-shop-wp-general-settings','abad_owner_button_text');
    
    // رنگ پس‌زمینه دکمه
    add_settings_field('abad_owner_button_bg','رنگ پس‌زمینه دکمه',function(){
        $v=get_option('abad_owner_button_bg','#d4a849');
        echo '<input type="text" name="abad_owner_button_bg" value="'.esc_attr($v).'" class="color-picker" data-default-color="#d4a849"/>';
    },'aradbranding-shop-wp-general-settings','abad_general_section');
    register_setting('aradbranding-shop-wp-general-settings','abad_owner_button_bg');
    
    // رنگ متن دکمه
    add_settings_field('abad_owner_button_text_color','رنگ متن دکمه',function(){
        $v=get_option('abad_owner_button_text_color','#000000');
        echo '<input type="text" name="abad_owner_button_text_color" value="'.esc_attr($v).'" class="color-picker" data-default-color="#000000"/>';
    },'aradbranding-shop-wp-general-settings','abad_general_section');
    register_setting('aradbranding-shop-wp-general-settings','abad_owner_button_text_color');
    
    // -------- سایر فیلدها --------
    add_settings_field('abad_custom_head','کد سفارشی Head',function(){
        $val = get_option('abad_custom_head', '');
        echo '<textarea name="abad_custom_head" rows="6" style="width:99%;max-width:700px;font-family:monospace;" placeholder="<!-- Google Analytics, Facebook Pixel, Meta Tags و سایر کدهای Head -->">'.esc_textarea($val).'</textarea>';
        echo '<p style="color:#666;font-size:13px;">این کد در بخش &lt;head&gt; تمام صفحات سایت قرار می‌گیرد. مناسب برای Google Analytics، Facebook Pixel، Meta Tags و...</p>';
    }, 'aradbranding-shop-wp-general-settings', 'abad_general_section');
    register_setting('aradbranding-shop-wp-general-settings', 'abad_custom_head');
    add_settings_field('abad_custom_footer','کد سفارشی Footer',function(){
        $val = get_option('abad_custom_footer', '');
        echo '<textarea name="abad_custom_footer" rows="6" style="width:99%;max-width:700px;font-family:monospace;" placeholder="<!-- کدهای تحلیل، اسکریپت‌های خاص و سایر کدهای Footer -->">'.esc_textarea($val).'</textarea>';
        echo '<p style="color:#666;font-size:13px;">این کد در انتهای صفحه (قبل از &lt;/body&gt;) قرار می‌گیرد. مناسب برای اسکریپت‌های تعاملی، چت و...</p>';
    }, 'aradbranding-shop-wp-general-settings', 'abad_general_section');
    register_setting('aradbranding-shop-wp-general-settings', 'abad_custom_footer');
    add_settings_field('abad_custom_css','CSS سفارشی',function(){
        $val = get_option('abad_custom_css', '');
        echo '<textarea name="abad_custom_css" rows="8" style="width:99%;max-width:700px;font-family:monospace;" placeholder="/* CSS سفارشی شما */\nbody {\n    /* استایل‌های دلخواه */\n}">'.esc_textarea($val).'</textarea>';
        echo '<p style="color:#666;font-size:13px;">CSS سفارشی برای تغییر ظاهر سایت. بدون تگ &lt;style&gt; بنویسید.</p>';
    }, 'aradbranding-shop-wp-general-settings', 'abad_general_section');
    register_setting('aradbranding-shop-wp-general-settings', 'abad_custom_css');
    add_settings_field('abad_custom_js','JavaScript سفارشی',function(){
        $val = get_option('abad_custom_js', '');
        echo '<textarea name="abad_custom_js" rows="8" style="width:99%;max-width:700px;font-family:monospace;" placeholder="// JavaScript سفارشی شما\ndocument.addEventListener(\'DOMContentLoaded\', function() {\n    // کد شما\n});">'.esc_textarea($val).'</textarea>';
        echo '<p style="color:#666;font-size:13px;">JavaScript سفارشی برای عملکردهای خاص. بدون تگ &lt;script&gt; بنویسید.</p>';
    }, 'aradbranding-shop-wp-general-settings', 'abad_general_section');
    register_setting('aradbranding-shop-wp-general-settings', 'abad_custom_js');
});

// ---- افزودن تگ <link rel="icon"> و کدهای سفارشی به هدر سایت ----
add_action('wp_head', function() {
    // Favicon
    $ico = get_option('abad_favicon','');
    if ($ico) {
        echo '<link rel="icon" type="image/png" href="'.esc_url($ico).'">';
    }
    
    // کد سفارشی Head
    $custom_head = get_option('abad_custom_head', '');
    if ($custom_head) {
        echo "\n" . $custom_head . "\n";
    }
    
    // CSS سفارشی
    $custom_css = get_option('abad_custom_css', '');
    if ($custom_css) {
        echo '<style type="text/css">' . "\n" . $custom_css . "\n" . '</style>' . "\n";
    }
});

// ---- افزودن کدهای سفارشی به Footer ----
add_action('wp_footer', function() {
    // کد سفارشی Footer
    $custom_footer = get_option('abad_custom_footer', '');
    if ($custom_footer) {
        echo "\n" . $custom_footer . "\n";
    }
    
    // JavaScript سفارشی
    $custom_js = get_option('abad_custom_js', '');
    if ($custom_js) {
        echo '<script type="text/javascript">' . "\n" . $custom_js . "\n" . '</script>' . "\n";
    }
});
// ---- enable media uploader in general tab
add_action('admin_enqueue_scripts', function($hook) {
    if (
        $hook === 'appearance_page_aradbranding-shop-wp-settings' &&
        (
            !isset($_GET['tab']) || $_GET['tab'] === 'general' ||
            !empty($_GET['tab']) && $_GET['tab'] === 'about'
        )
    ) {
        wp_enqueue_media();
    }
});

// ثبت optionهای صفحه single post
add_action('admin_init', function () {
    add_settings_section('abad_post_section', __('تنظیمات صفحه نوشته (Single)', 'aradbranding-shop-wp'), function () {
        echo '<p style="margin-bottom:20px;">شخصی‌سازی بخش‌ها و رنگ‌های صفحه سینگل مقالات</p>';
    }, 'aradbranding-shop-wp-post-settings');
    // فعال/غیرفعال سازی بخش‌ها
    add_settings_field('single_show_category','نمایش دسته‌بندی',function(){
        echo '<input type="checkbox" name="single_show_category" value="1" '.(get_option('single_show_category',1)?'checked':'').'> نمایش دسته';
    },'aradbranding-shop-wp-post-settings','abad_post_section');
    register_setting('aradbranding-shop-wp-post-settings','single_show_category');
    add_settings_field('single_show_author','نمایش نویسنده',function(){
        echo '<input type="checkbox" name="single_show_author" value="1" '.(get_option('single_show_author',1)?'checked':'').'> نمایش نویسنده';
    },'aradbranding-shop-wp-post-settings','abad_post_section');
    register_setting('aradbranding-shop-wp-post-settings','single_show_author');
    add_settings_field('single_show_date','نمایش تاریخ',function(){
        echo '<input type="checkbox" name="single_show_date" value="1" '.(get_option('single_show_date',1)?'checked':'').'> نمایش تاریخ';
    },'aradbranding-shop-wp-post-settings','abad_post_section');
    register_setting('aradbranding-shop-wp-post-settings','single_show_date');
    add_settings_field('single_show_read_time','نمایش زمان مطالعه',function(){
        echo '<input type="checkbox" name="single_show_read_time" value="1" '.(get_option('single_show_read_time',1)?'checked':'').'> نمایش زمان مطالعه';
    },'aradbranding-shop-wp-post-settings','abad_post_section');
    register_setting('aradbranding-shop-wp-post-settings','single_show_read_time');
    add_settings_field('single_show_share','نمایش اشتراک‌گذاری',function(){
        echo '<input type="checkbox" name="single_show_share" value="1" '.(get_option('single_show_share',1)?'checked':'').'> نمایش بخش اشتراک‌گذاری';
    },'aradbranding-shop-wp-post-settings','abad_post_section');
    register_setting('aradbranding-shop-wp-post-settings','single_show_share');
    add_settings_field('single_show_comments','نمایش فرم نظرات',function(){
        echo '<input type="checkbox" name="single_show_comments" value="1" '.(get_option('single_show_comments',1)?'checked':'').'> نمایش بخش نظرات';
    },'aradbranding-shop-wp-post-settings','abad_post_section');
    register_setting('aradbranding-shop-wp-post-settings','single_show_comments');
    add_settings_field('single_show_related','نمایش مقالات مرتبط',function(){
        echo '<input type="checkbox" name="single_show_related" value="1" '.(get_option('single_show_related',1)?'checked':'').'> نمایش بخش مقالات مرتبط';
    },'aradbranding-shop-wp-post-settings','abad_post_section');
    register_setting('aradbranding-shop-wp-post-settings','single_show_related');
    add_settings_field('single_show_tags','نمایش برچسب‌ها',function(){
        echo '<input type="checkbox" name="single_show_tags" value="1" '.(get_option('single_show_tags',1)?'checked':'').'> نمایش بخش برچسب‌ها';
    },'aradbranding-shop-wp-post-settings','abad_post_section');
    register_setting('aradbranding-shop-wp-post-settings','single_show_tags');
    // رنگ‌ها
    add_settings_field('single_title_color','رنگ تیتر مقاله',function(){
        $c=get_option('single_title_color','#2c3e50');
        echo '<input type="color" name="single_title_color" value="'.esc_attr($c).'">';
    },'aradbranding-shop-wp-post-settings','abad_post_section');
    register_setting('aradbranding-shop-wp-post-settings','single_title_color');
    add_settings_field('single_bg_color','رنگ پس زمینه',function(){
        $c=get_option('single_bg_color','#fff');
        echo '<input type="color" name="single_bg_color" value="'.esc_attr($c).'">';
    },'aradbranding-shop-wp-post-settings','abad_post_section');
    register_setting('aradbranding-shop-wp-post-settings','single_bg_color');
    add_settings_field('single_text_color','رنگ متن مقاله',function(){
        $c=get_option('single_text_color','#2c3e50');
        echo '<input type="color" name="single_text_color" value="'.esc_attr($c).'">';
    },'aradbranding-shop-wp-post-settings','abad_post_section');
    register_setting('aradbranding-shop-wp-post-settings','single_text_color');
    add_settings_field('single_line_color','رنگ جداکننده‌ها',function(){
        $c=get_option('single_line_color','#f1ecf3');
        echo '<input type="color" name="single_line_color" value="'.esc_attr($c).'">';
    },'aradbranding-shop-wp-post-settings','abad_post_section');
    register_setting('aradbranding-shop-wp-post-settings','single_line_color');
    add_settings_field('single_share_bg','رنگ زمینه بخش اشتراک‌گذاری',function(){
        $c=get_option('single_share_bg','#f093fb');
        echo '<input type="color" name="single_share_bg" value="'.esc_attr($c).'">';
    },'aradbranding-shop-wp-post-settings','abad_post_section');
    register_setting('aradbranding-shop-wp-post-settings','single_share_bg');
    add_settings_field('single_share_btn','رنگ دکمه‌های اشتراک‌گذاری',function(){
        $c=get_option('single_share_btn','rgba(255,255,255,0.2)');
        echo '<input type="color" name="single_share_btn" value="'.esc_attr($c).'"> <span style="font-size:13px;color:#888;">(در صورت پشتیبانی مرورگر)</span>';
    },'aradbranding-shop-wp-post-settings','abad_post_section');
    register_setting('aradbranding-shop-wp-post-settings','single_share_btn');
    add_settings_field('single_comments_bg','رنگ پس‌زمینه نظرات',function(){
        $c=get_option('single_comments_bg','#fff');
        echo '<input type="color" name="single_comments_bg" value="'.esc_attr($c).'">';
    },'aradbranding-shop-wp-post-settings','abad_post_section');
    register_setting('aradbranding-shop-wp-post-settings','single_comments_bg');
    add_settings_field('single_meta_bg','رنگ پس‌زمینه نوار متا',function(){
        $c=get_option('single_meta_bg','#f6f4fc');
        echo '<input type="color" name="single_meta_bg" value="'.esc_attr($c).'">';
    },'aradbranding-shop-wp-post-settings','abad_post_section');
    register_setting('aradbranding-shop-wp-post-settings','single_meta_bg');
    add_settings_field('single_meta_text','رنگ متن نوار متا',function(){
        $c=get_option('single_meta_text','#6d488f');
        echo '<input type="color" name="single_meta_text" value="'.esc_attr($c).'">';
    },'aradbranding-shop-wp-post-settings','abad_post_section');
    register_setting('aradbranding-shop-wp-post-settings','single_meta_text');
});

// ===== سیستم آپدیت خودکار قالب =====
add_filter('pre_set_site_transient_update_themes', 'abad_check_for_theme_update');
function abad_check_for_theme_update($transient) {
    if (empty($transient->checked)) {
        return $transient;
    }
    
    $theme_slug = 'Aradbranding-shop-wp';
    $current_version = wp_get_theme($theme_slug)->get('Version');
    $update_url = 'https://wp.javidmirzaei.com/theme-updates/aradbranding-shop-wp.json';
    
    // دریافت اطلاعات آپدیت از سرور
    $response = wp_remote_get($update_url, [
        'timeout' => 10,
        'headers' => [
            'Accept' => 'application/json'
        ]
    ]);
    
    if (is_wp_error($response)) {
        return $transient;
    }
    
    $data = json_decode(wp_remote_retrieve_body($response), true);
    
    if (!$data || !isset($data['version'])) {
        return $transient;
    }
    
    // بررسی نسخه جدید
    if (version_compare($current_version, $data['version'], '<')) {
        $transient->response[$theme_slug] = [
            'theme'       => $theme_slug,
            'new_version' => $data['version'],
            'url'         => $data['details_url'] ?? '',
            'package'     => $data['download_url'] ?? '',
            'requires'    => $data['requires'] ?? '6.0',
            'requires_php'=> $data['requires_php'] ?? '7.4',
        ];
    }
    
    return $transient;
}

// نمایش اطلاعات تغییرات (Changelog)
add_filter('themes_api', 'abad_theme_update_info', 10, 3);
function abad_theme_update_info($res, $action, $args) {
    if ($action !== 'theme_information') {
        return $res;
    }
    
    if ($args->slug !== 'Aradbranding-shop-wp') {
        return $res;
    }
    
    $update_url = 'https://wp.javidmirzaei.com/theme-updates/aradbranding-shop-wp.json';
    $response = wp_remote_get($update_url, ['timeout' => 10]);
    
    if (is_wp_error($response)) {
        return $res;
    }
    
    $data = json_decode(wp_remote_retrieve_body($response), true);
    
    if (!$data) {
        return $res;
    }
    
    $res = (object) [
        'name'          => 'قالب آرادبرندینگ شاپ',
        'slug'          => 'Aradbranding-shop-wp',
        'version'       => $data['version'] ?? '1.0.0',
        'author'        => '<a href="https://aradbranding.com">Aradbranding</a>',
        'homepage'      => 'https://aradbranding.com/fa',
        'requires'      => $data['requires'] ?? '6.0',
        'tested'        => $data['tested'] ?? '6.5',
        'requires_php'  => $data['requires_php'] ?? '7.4',
        'download_link' => $data['download_url'] ?? '',
        'sections'      => [
            'description' => 'قالب اختصاصی فروشگاهی توسعه داده شده توسط آرادبرندینگ',
            'changelog'   => $data['changelog'] ?? '<p>به‌روزرسانی جدید</p>',
        ],
    ];
    
    return $res;
}

// ===== بنر ثابت آرادبرندینگ در بالای پیشخوان =====
add_action('admin_notices', function() {
    $logo_url = get_template_directory_uri() . '/images/arad-logo.png';
    ?>
    <div class="aradbranding-admin-banner">
        <div class="abad-banner-container">
            <div class="abad-banner-left">
                <img src="<?php echo esc_url($logo_url); ?>" alt="آرادبرندینگ" class="abad-banner-logo">
                <div class="abad-banner-text">
                    <h2 class="abad-banner-title">قالب آرادبرندینگ شاپ</h2>
                    <p class="abad-banner-subtitle">توسعه داده شده توسط <strong>آرادبرندینگ</strong></p>
                </div>
            </div>
            
            <div class="abad-banner-right">
                <div class="abad-plugins-compact">
                    <span class="plugins-label">📦 افزونه‌های ضروری:</span>
                    <span class="plugins-list-compact">Classic Editor (ویرایشگر کلاسیک) • LiteSpeed Cache (لایت اسپید کش)</span>
                </div>
                <div class="abad-banner-actions">
                    <a href="<?php echo admin_url('themes.php?page=aradbranding-shop-wp-settings'); ?>" class="abad-btn-banner settings">
                        ⚙️ تنظیمات قالب
                    </a>
                    <a href="https://aradbranding.com/fa" target="_blank" class="abad-btn-banner website">
                        🌐 وبسایت
                    </a>
                </div>
            </div>
        </div>
    </div>
    
    <style>
    .aradbranding-admin-banner {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        margin: 40px 20px 20px 20px;
        padding: 0;
        border: none;
        border-radius: 16px;
        box-shadow: 0 8px 30px rgba(102, 126, 234, 0.3);
        font-family: 'Vazir', Tahoma, sans-serif;
        position: relative;
        overflow: hidden;
    }
    
    .aradbranding-admin-banner::before {
        content: '';
        position: absolute;
        top: -50%;
        right: -10%;
        width: 300px;
        height: 300px;
        background: rgba(255,255,255,0.1);
        border-radius: 50%;
        pointer-events: none;
    }
    
    .abad-banner-container {
        display: flex;
        align-items: center;
        justify-content: space-between;
        padding: 24px 32px;
        position: relative;
        z-index: 1;
        gap: 32px;
        flex-wrap: wrap;
    }
    
    .abad-banner-left {
        display: flex;
        align-items: center;
        gap: 20px;
    }
    
    .abad-banner-logo {
        width: 80px;
        height: 80px;
        border-radius: 16px;
        border: 3px solid rgba(255,255,255,0.3);
        box-shadow: 0 4px 20px rgba(0,0,0,0.2);
        background: white;
        padding: 8px;
        object-fit: contain;
    }
    
    .abad-banner-text {
        direction: rtl;
    }
    
    .abad-banner-title {
        color: white;
        font-size: 1.6rem;
        font-weight: 900;
        margin: 0 0 8px 0;
        text-shadow: 0 2px 10px rgba(0,0,0,0.2);
    }
    
    .abad-banner-subtitle {
        color: rgba(255,255,255,0.95);
        font-size: 1.1rem;
        margin: 0;
        font-weight: 600;
    }
    
    .abad-banner-subtitle strong {
        color: #ffd062;
        font-weight: 800;
    }
    
    .abad-banner-right {
        display: flex;
        flex-direction: column;
        gap: 16px;
        align-items: flex-end;
    }
    
    .abad-plugins-compact {
        background: rgba(255,255,255,0.15);
        backdrop-filter: blur(10px);
        padding: 12px 20px;
        border-radius: 12px;
        border: 1px solid rgba(255,255,255,0.2);
        direction: rtl;
    }
    
    .plugins-label {
        color: white;
    font-weight: 700;
        font-size: 0.95rem;
        margin-left: 12px;
    }
    
    .plugins-list-compact {
        color: rgba(255,255,255,0.9);
        font-size: 0.9rem;
        font-weight: 600;
    }
    
    .abad-banner-actions {
        display: flex;
        gap: 12px;
    }
    
    .abad-btn-banner {
        padding: 12px 24px;
        border-radius: 50px;
        text-decoration: none;
        font-weight: 700;
        font-size: 0.95rem;
        transition: all 0.3s ease;
        display: inline-flex;
        align-items: center;
        gap: 8px;
        box-shadow: 0 4px 15px rgba(0,0,0,0.2);
    }
    
    .abad-btn-banner.settings {
        background: white;
        color: #667eea;
    }
    
    .abad-btn-banner.settings:hover {
        transform: translateY(-3px);
        box-shadow: 0 6px 25px rgba(255,255,255,0.4);
        color: #667eea;
    }
    
    .abad-btn-banner.website {
        background: rgba(255,255,255,0.2);
        backdrop-filter: blur(10px);
        border: 2px solid rgba(255,255,255,0.3);
        color: white;
    }
    
    .abad-btn-banner.website:hover {
        transform: translateY(-3px);
        background: rgba(255,255,255,0.3);
        box-shadow: 0 6px 25px rgba(255,255,255,0.3);
        color: white;
    }
    
    @media (max-width: 1200px) {
        .abad-banner-container {
            flex-direction: column;
            align-items: flex-start;
            gap: 20px;
        }
        
        .abad-banner-right {
            width: 100%;
            align-items: stretch;
        }
        
        .abad-plugins-compact {
            text-align: center;
        }
        
        .abad-banner-actions {
            justify-content: center;
        }
    }
    
    @media (max-width: 768px) {
        .aradbranding-admin-banner {
            margin: 10px 10px 10px 0;
        }
        
        .abad-banner-container {
            padding: 20px;
        }
        
        .abad-banner-logo {
            width: 60px;
            height: 60px;
        }
        
        .abad-banner-title {
            font-size: 1.3rem;
        }
        
        .abad-banner-subtitle {
            font-size: 0.95rem;
        }
        
        .abad-banner-actions {
            flex-direction: column;
            width: 100%;
        }
        
        .abad-btn-banner {
            justify-content: center;
            width: 100%;
        }
  }
  </style>
  <?php
});

add_action('admin_init', function () {
    add_settings_section('abad_about_section', __('تنظیمات صفحه درباره ما', 'aradbranding-shop-wp'), function() {
        echo '<p>متن یا تنظیمات صفحه درباره ما را اینجا ویرایش کنید.</p>';
    }, 'aradbranding-shop-wp-about-settings');

    add_settings_field('about_page_title', __('عنوان درباره ما', 'aradbranding-shop-wp'), function() {
        $val = get_option('about_page_title', 'درباره ما');
        echo '<input type="text" name="about_page_title" value="'.esc_attr($val).'" style="width:320px">';
    }, 'aradbranding-shop-wp-about-settings', 'abad_about_section');
    register_setting('aradbranding-shop-wp-about-settings', 'about_page_title');

    // متن درباره ما (جدید به نام abad_about_text و حذف قبلی)
    add_settings_field('abad_about_text', __('متن درباره ما', 'aradbranding-shop-wp'), function() {
        $val = get_option('abad_about_text', 'متنی درباره آرادبرندینگ اینجا قرار می‌گیرد.');
        echo '<textarea name="abad_about_text" rows="5" style="width:98%;max-width:570px">'.esc_textarea($val).'</textarea>';
    }, 'aradbranding-shop-wp-about-settings', 'abad_about_section');
    register_setting('aradbranding-shop-wp-about-settings', 'abad_about_text');

    add_settings_field('abad_about_image', __('عکس درباره ما', 'aradbranding-shop-wp'), function() {
        $img = get_option('abad_about_image', '');
        echo '<input type="text" id="abad_about_image" name="abad_about_image" value="' . esc_attr($img) . '" style="width:69%" /> ';
        echo '<button class="button" id="btn_about_img_up">انتخاب/آپلود عکس</button>';
        if($img) echo '<br><img src="' . esc_url($img) . '" alt="aboutimg" style="max-width:120px;margin-top:9px;border-radius:9px;box-shadow:0 2px 9px #e9c3e17c;">';
        ?>
        <script>document.addEventListener('DOMContentLoaded', function(){
            var btn = document.getElementById('btn_about_img_up');
            if(btn){ btn.onclick = function(e){
                e.preventDefault();
                if(window._abadAboutImgFrm){window._abadAboutImgFrm.open();return;}
                window._abadAboutImgFrm = wp.media({title:'انتخاب تصویر', button:{text:'انتخاب'}, multiple:false});
                window._abadAboutImgFrm.on('select',function(){
                    var att = window._abadAboutImgFrm.state().get('selection').first().toJSON();
                    document.getElementById('abad_about_image').value = att.url;
                });
                window._abadAboutImgFrm.open();
            };}
        });</script>
        <?php
    }, 'aradbranding-shop-wp-about-settings', 'abad_about_section');
    register_setting('aradbranding-shop-wp-about-settings', 'abad_about_image');
});