<?php
?><!DOCTYPE html>
<html <?php language_attributes(); ?> >
<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php wp_head(); ?>
</head>
<body <?php body_class(); ?> >
<?php
$bg = esc_attr(get_option('abad_header_footer_color', '#2b2b2b'));
$font_size = esc_attr(get_option('abad_header_font_size', '15'));
$font_color = esc_attr(get_option('abad_header_font_color', '#fff'));
$menu_hover = esc_attr(get_option('abad_header_menu_hover_color', '#383838'));
$menu_active = esc_attr(get_option('abad_header_menu_active_color', '#ffd062'));
$menu_active_bg = esc_attr(get_option('abad_header_menu_active_bg_color', $menu_hover));
?>
<style>
:root {
  --ar-menu-hover: <?php echo $menu_hover; ?>;
  --ar-menu-active: <?php echo $menu_active; ?>;
  --ar-menu-active-bg: <?php echo $menu_active_bg; ?>;
}
.site-header, .site-header * {
  color: <?php echo $font_color; ?> !important;
  font-size: <?php echo $font_size; ?>px;
}
.main-menu > li > a:hover,
.main-menu > li:focus > a {
  background: var(--ar-menu-hover);
  color: var(--ar-menu-active);
}
.main-menu > li.current-menu-item > a,
.main-menu > li > a.active {
  background: var(--ar-menu-active-bg) !important;
  color: var(--ar-menu-active) !important;
}
</style>
<header class="site-header" style="--header-bg: <?php echo $bg; ?>; background: <?php echo $bg; ?>;">
    <div class="header-inner">
        <!-- Right: Logo -->
        <div class="branding">
            <?php
            $abad_logo = get_option('abad_custom_logo', '');
            if (!empty($abad_logo)) {
                echo '<img src="' . esc_url($abad_logo) . '" alt="logo" style="height:46px;max-width:110px;object-fit:contain;border-radius:9px;">';
            } elseif (function_exists('the_custom_logo') && has_custom_logo()) {
                the_custom_logo();
            } else {
                echo '<span class="site-logo-placeholder">ab</span>';
            }
            ?>
        </div>
        <button class="menu-toggle" type="button" aria-expanded="false" aria-label="باز کردن منو" aria-controls="primary-navigation">
            <span class="menu-line"></span>
            <span class="menu-line"></span>
            <span class="menu-line"></span>
        </button>
        <!-- Center: Menu -->
        <nav class="main-nav" id="primary-navigation" aria-hidden="true">
            <?php
            wp_nav_menu([
                'theme_location' => 'main-menu',
                'container'      => false,
                'menu_class'     => 'main-menu',
                'fallback_cb'    => false,
                'depth'          => 1
            ]);
            ?>
            <div class="mobile-menu-search" role="search">
                <form role="search" method="get" action="<?php echo esc_url(home_url('/')); ?>">
                    <input type="search" name="s" placeholder="جست و جو..." />
                    <button type="submit">🔎</button>
                </form>
            </div>
        </nav>
        <div class="menu-overlay" aria-hidden="true"></div>
        <!-- Left: Search -->
        <div class="header-search">
            <form role="search" method="get" action="<?php echo esc_url(home_url('/')); ?>">
                <input type="search" name="s" placeholder="جست و جو برای ..." />
                <button type="submit">🔎</button>
            </form>
        </div>
    </div>
</header>
<script>
document.addEventListener('DOMContentLoaded', function() {
    var toggle = document.querySelector('.menu-toggle');
    var nav = document.getElementById('primary-navigation');
    var overlay = document.querySelector('.menu-overlay');
    if (!toggle || !nav) {
        return;
    }
    function closeMenu() {
        nav.classList.remove('is-open');
        nav.setAttribute('aria-hidden', 'true');
        toggle.setAttribute('aria-expanded', 'false');
        document.body.classList.remove('menu-open');
        if (overlay) {
            overlay.classList.remove('is-active');
        }
    }
    toggle.addEventListener('click', function() {
        var isOpen = nav.classList.toggle('is-open');
        nav.setAttribute('aria-hidden', isOpen ? 'false' : 'true');
        toggle.setAttribute('aria-expanded', isOpen ? 'true' : 'false');
        document.body.classList.toggle('menu-open', isOpen);
        if (overlay) {
            overlay.classList.toggle('is-active', isOpen);
        }
    });
    nav.addEventListener('click', function(event) {
        if (event.target.closest('a')) {
            closeMenu();
        }
    });
    var mq = window.matchMedia('(min-width: 901px)');
    function handleChange(e) {
        if (e.matches) {
            closeMenu();
        }
    }
    if (typeof mq.addEventListener === 'function') {
        mq.addEventListener('change', handleChange);
    } else if (typeof mq.addListener === 'function') {
        mq.addListener(handleChange);
    }
    if (overlay) {
        overlay.addEventListener('click', closeMenu);
    }
    document.addEventListener('keydown', function(event) {
        if (event.key === 'Escape' && nav.classList.contains('is-open')) {
            closeMenu();
        }
    });
});
</script>
<?php
// ... ادامه قالب ...
