<?php
// Silence is golden.
// پوسته Aradbranding-shop-wp نصب شد.
get_header();
// دریافت رنگ‌های سفارشی کارت محصولات از تنظیمات
$card_bg = get_option('abad_product_card_bg', '#ffffff');
$price_color = get_option('abad_product_price_color', '#b3006d');
$btn_bg = get_option('abad_product_btn_bg', '#ffd062');
$btn_text = get_option('abad_product_btn_text', '#111111');
// تابع تبدیل اعداد انگلیسی به فارسی
if (!function_exists('persian_number_format')) {
function persian_number_format($number) {
    $persian_numbers = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'];
    $english_numbers = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'];
    $formatted = number_format($number);
    return str_replace($english_numbers, $persian_numbers, $formatted);
}}
?>
<main class="main-products-list">
  <div class="products-grid">
    <?php
    $loop = new WP_Query([
      'post_type' => 'abad_product',
      'posts_per_page' => 20,
      'paged' => max(1, get_query_var('paged'))
    ]);
    if ($loop->have_posts()) :
      while ($loop->have_posts()) : $loop->the_post();
        $pid = get_the_ID();
        // عکس شاخص یا عکس جایگزین
        $thumb = get_the_post_thumbnail_url($pid, 'medium') ?: 'https://via.placeholder.com/340x225?text=No+Image';
        $title = get_the_title();
        $url = get_permalink();
        $ptype = get_post_meta($pid, '_abad_price_type', true) ?: 'fixed';
        $price = get_post_meta($pid, '_abad_price', true);
        $price_from = get_post_meta($pid, '_abad_price_from', true);
        $price_to = get_post_meta($pid, '_abad_price_to', true);
        $price_html = '';
        if($ptype === 'fixed')
          $price_html = $price ? persian_number_format($price).' تومان' : '';
        elseif($ptype === 'range')
          $price_html = ($price_from && $price_to) ? 'از '.persian_number_format($price_from).' تا '.persian_number_format($price_to).' تومان' : '';
        elseif($ptype === 'tavafoghi')
          $price_html = 'توافقی';
    ?>
      <div class="product-card">
        <a href="<?php echo esc_url($url); ?>" class="product-thumb"><img src="<?php echo esc_url($thumb); ?>" alt="<?php echo esc_attr($title); ?>" /></a>
        <div class="product-content">
          <h3 class="product-title"><?php echo esc_html($title); ?></h3>
          <div class="product-price"><?php echo $price_html; ?></div>
          <a href="<?php echo esc_url($url); ?>" class="product-detail-btn">مشخصات محصول</a>
        </div>
      </div>
    <?php endwhile; else: ?>
      <div>محصولی درج نشده است.</div>
    <?php endif; wp_reset_postdata(); ?>
  </div>
</main>
<?php
// --- نمایش اطلاعات مالک سایت در بالای صفحه - بعد از فاوآیکون یا قبل از محتوای پست ---
$oname = get_option('abad_owner_name','');
$ophone = get_option('abad_owner_phone','');
$oimg = get_option('abad_owner_avatar','');
if(($oname || $ophone || $oimg) && is_single() && !is_home()): ?>
  <div class="abad-owner-box" style="direction:rtl;max-width:480px;background:#fff3e5b0;border-radius:15px;margin:27px auto 24px auto;padding:14px 16px 15px 16px;box-shadow:0 3px 16px #ffe0c940;display:flex;gap:19px;align-items:center;">
    <?php if($oimg): ?><img src="<?php echo esc_url($oimg); ?>" alt="مالک سایت" style="width:64px;height:64px;border-radius:50%;box-shadow:0 2px 8px #ad9b8999;object-fit:cover;background:#fff;flex-shrink:0;"/><?php endif; ?>
    <div style="flex:1 1 0;">
      <?php if($oname): ?><div style="font-weight:800;font-size:1.23em;color:#a5525f;line-height:1.8;">👤 <?php echo esc_html($oname); ?></div><?php endif; ?>
      <?php if($ophone): ?><div style="font-size:1.03em;color:#6e4309;direction:ltr;">☎ <b><?php echo esc_html($ophone); ?></b></div><?php endif; ?>
    </div>
  </div>
<?php endif; ?>
<style>
/* استایل‌های اصلی */
.main-products-list { 
  max-width: 1460px; 
  margin: 0 auto; 
  padding: 22px 12px; 
}

/* Grid محصولات - پیش‌فرض دسکتاپ */
.products-grid { 
  display: grid !important; 
  grid-template-columns: repeat(4, 1fr) !important; 
  gap: 20px 15px !important; 
}

/* استایل کارت محصول */
.product-card { 
  background: <?php echo esc_attr($card_bg); ?>;
  border-radius: 13px;
  box-shadow: 0 2px 14px #cacaca1d;
  overflow: hidden;
  transition: box-shadow .22s;
  position: relative;
  display: flex;
  flex-direction: column;
  align-items: center;
  max-width: 100%; 
}
.product-card:hover { box-shadow: 0 7px 25px #99999932; }
.product-thumb { display: block; width: 100%; height: 280px; overflow: hidden; }
.product-thumb img { width: 100%; height: 100%; object-fit: cover; }
.product-content { padding: 13px 13px 12px; width: 100%; text-align: center; }
.product-title { font-weight: bold; font-size: 1.1rem; color: #242424; margin: 0 0 5px; line-height: 1.4; }
.product-price { color: <?php echo esc_attr($price_color); ?>; font-weight: 600; font-size: 1rem; margin: 0 0 11px 0; letter-spacing: .2px; }
.product-detail-btn { 
  display: block; 
  background: <?php echo esc_attr($btn_bg); ?>; 
  color: <?php echo esc_attr($btn_text); ?>; 
  font-weight: 600; 
  text-decoration: none; 
  padding: 8px 23px; 
  border-radius: 8px; 
  font-size: .98rem; 
  transition: background .15s; 
  margin: 0 auto; 
  box-shadow: 0 2px 4px #ffeab720;
}
.product-detail-btn:hover { background: #faaf40; color: #fff; }

/* ===== ریسپانسیو ===== */
@media only screen and (max-width: 1200px) { 
  .products-grid { 
    grid-template-columns: repeat(3, 1fr) !important; 
  } 
}

@media only screen and (max-width: 900px) { 
  .products-grid { 
    grid-template-columns: repeat(2, 1fr) !important; 
  } 
}

@media only screen and (max-width: 768px) { 
  .products-grid { 
    grid-template-columns: repeat(2, 1fr) !important; 
    gap: 15px 12px !important; 
  }
  .product-thumb { height: 200px !important; }
  .product-title { font-size: 1rem !important; }
  .product-price { font-size: 0.95rem !important; }
  .product-detail-btn { padding: 7px 15px !important; font-size: 0.9rem !important; }
}

@media only screen and (max-width: 600px) { 
  .products-grid { 
    grid-template-columns: repeat(2, 1fr) !important; 
    gap: 12px 10px !important; 
  } 
}

@media only screen and (max-width: 480px) { 
  .products-grid { 
    grid-template-columns: repeat(2, 1fr) !important; 
    gap: 10px 8px !important; 
  }
  .product-thumb { height: 180px !important; }
}
</style>
<?php get_footer(); ?>
