<?php /* Template Name: درباره ما Aradbranding */ get_header(); ?>
<main class="about-modern-bg">
  <div class="about-main-card">
    <?php $img = get_option('abad_about_image',''); if($img): ?>
    <div class="about-img-wrap"><img src="<?php echo esc_url($img); ?>" alt="about" /></div>
    <?php endif; ?>
    <h1 class="about-title"><?php echo esc_html(get_option('about_page_title', 'درباره ما')); ?></h1>
    <div class="about-description">
      <?php echo nl2br(esc_html(get_option('abad_about_text','متنی برای معرفی شرکت درج نشده است.'))); ?>
    </div>
  </div>
</main>
<style>
body, main.about-modern-bg { background: linear-gradient(120deg,#f9f9fa 0%, #f3eae3 100%) !important; }
.about-modern-bg { min-height:83vh; display:flex; justify-content:center; align-items:center; }
.about-main-card{background:rgba(255,255,255,0.97);border-radius:22px;box-shadow:0 9px 58px #dcccdc2c;padding:48px 28px 44px 28px;max-width:800px;width:96%;margin:45px auto 65px auto;animation:fadeCard .77s cubic-bezier(.34,1.56,.64,1);text-align:center;}
@keyframes fadeCard{0%{opacity:.2;transform:translateY(40px);}100%{opacity:1;transform:none}}
.about-img-wrap{margin:0 auto 15px auto;display:flex;justify-content:center;align-items:center;}
.about-img-wrap img{max-width:160px;max-height:150px;border-radius:16px;box-shadow:0 4px 24px #decfaa3b;object-fit:cover;}
.about-title{color:#ab872c;font-size:2.33rem;font-weight:900;margin-bottom:23px;letter-spacing:-1.8px;font-family:Vazir,sans-serif;}
.about-description{color:#333;font-size:1.15em;line-height:2.05;font-family:Vazir,Tahoma,sans-serif;text-align:justify;margin:0 auto 0 auto;max-width:580px;}
@media (max-width:900px){.about-main-card{padding:32px 13px 28px 13px;}.about-title{font-size:1.33rem;}.about-description{font-size:.99em;}.about-img-wrap img{max-width:88px;}}
</style>
<?php get_footer(); ?>
