<?php
get_header();
// خواندن رنگ‌های تنظیمات صفحه بلاگ
$blog_card_bg = get_option('abad_blog_card_bg', '#fff');
$blog_btn_bg = get_option('abad_blog_btn_bg', '#ffd062');
$blog_title_color = get_option('abad_blog_title_color', '#822253');
$blog_text_color = get_option('abad_blog_text_color', '#303030');
$blog_excerpt_color = get_option('abad_blog_excerpt_color', '#303030');
?>
<main class="main-blog-list">
  <h1 class="blog-title">مقالات</h1>
  <div class="blog-grid">
    <?php
    $paged = max( 1, get_query_var( 'paged' ) );
    $query = new WP_Query([
      'post_type' => 'post',
      'posts_per_page' => 8,
      'paged' => $paged,
    ]);
    if ($query->have_posts()) :
      while ($query->have_posts()) : $query->the_post();
        $pid = get_the_ID();
        $thumb = get_the_post_thumbnail_url($pid, 'medium') ?: 'https://via.placeholder.com/340x225?text=No+Image';
        $title = get_the_title();
        $excerpt = get_the_excerpt();
        $permalink = get_permalink();
    ?>
      <div class="blog-card">
        <a href="<?php echo esc_url($permalink); ?>" class="blog-thumb">
          <div class="blog-thumb-bg"></div>
          <img src="<?php echo esc_url($thumb); ?>" alt="<?php echo esc_attr($title); ?>" />
        </a>
        <div class="blog-content">
          <h2 class="blog-post-title"><a href="<?php echo esc_url($permalink); ?>"><?php echo esc_html($title); ?></a></h2>
          <div class="blog-excerpt"><?php echo esc_html(mb_substr(strip_tags($excerpt),0,100)); ?> ...</div>
          <a href="<?php echo esc_url($permalink); ?>" class="blog-detail-btn">ادامه مطلب</a>
        </div>
      </div>
    <?php endwhile; else: ?>
      <div>مقاله‌ای یافت نشد.</div>
    <?php endif; ?>
  </div>
  <div class="blog-pagination">
    <?php
      echo paginate_links([
        'total' => $query->max_num_pages,
        'current' => $paged,
        'prev_text' => '«',
        'next_text' => '»',
      ]);
      wp_reset_postdata();
    ?>
  </div>
</main>
<style>
.main-blog-list { max-width: 1330px; margin: 0 auto; padding: 32px 14px; }
.blog-title {text-align:center;font-size:2.04rem;margin-bottom:38px;color:<?php echo esc_attr($blog_title_color); ?>;letter-spacing:.3px;}
.blog-grid { display: grid; grid-template-columns: repeat(4, 1fr); gap: 28px 18px; }
@media (max-width:1200px){ .blog-grid{grid-template-columns:repeat(3,1fr);} }
@media (max-width:900px){ .blog-grid{grid-template-columns:repeat(2,1fr);} }
@media (max-width:700px){ .blog-grid{grid-template-columns:repeat(2,1fr); gap:18px 12px;} }
@media (max-width:450px){ .blog-grid{grid-template-columns:repeat(2,1fr); gap:14px 10px;} }
.blog-card { background: <?php echo esc_attr($blog_card_bg); ?>; border-radius: 15px; box-shadow: 0 2px 17px #e6ccd82b; overflow: hidden; transition: box-shadow .2s; display: flex; flex-direction: column; min-height:360px; }
.blog-card:hover { box-shadow: 0 7px 26px #cfaeae2c; }
.blog-thumb { display: block; width: 100%; height: 190px; overflow: hidden; }
.blog-thumb img { width: 100%; height: 100%; object-fit: cover; }
.blog-content { padding: 16px 15px 17px; flex:1 1 0; display: flex; flex-direction: column; justify-content: space-between; }
.blog-post-title { font-weight: bold; font-size: 1.15rem; color: <?php echo esc_attr($blog_title_color); ?>; margin: 0 0 13px; line-height: 1.44; }
.blog-post-title a { color: inherit; text-decoration: none; }
.blog-post-title a:hover { color: #ff9800; }
.blog-excerpt { color: <?php echo esc_attr($blog_excerpt_color); ?>; font-size:.95rem; margin-bottom: 19px; min-height:48px; }
.blog-detail-btn { display: inline-block; background: <?php echo esc_attr($blog_btn_bg); ?>; color: <?php echo esc_attr($blog_text_color); ?>; font-weight: 600; text-decoration: none; padding: 7px 19px; border-radius: 8px; font-size: .98rem; transition: background .15s; box-shadow: 0 2px 4px #ffeab720; text-align:center; min-width:120px; width:100%; max-width:180px; margin:0 auto; }
.blog-detail-btn:hover { background: #faaf40; color: #fff; }
.blog-pagination { margin-top: 44px; text-align: center; }
.blog-pagination .page-numbers { display: inline-block; margin: 0 4px; padding: 6px 14px; background: #fff; border: 1px solid #ffd062; color: #b3006d; border-radius: 7px; font-weight: 600; text-decoration: none; font-size:.98rem; }
.blog-pagination .page-numbers.current { background: #ffd062; color: #fff; border-color: #ffb100; }
.blog-pagination .page-numbers:hover { background: #ffb100; color: #fff; }
</style>
<?php get_footer(); ?>
