<?php /* Template Name: Contact Modern */ get_header(); ?>
<?php
$btn_bg = get_option('contact_btn_bg', '#faaf40');
$btn_hover = get_option('contact_btn_hover', '#fbb81a');
$btn_text = get_option('contact_btn_text', '#ffffff');

// دریافت اطلاعات تماس از تنظیمات
$email_enable = get_option('contact_email_enable', '1');
$email_link = get_option('contact_email_link', 'info@aradbranding.com');
$mobile_enable = get_option('contact_mobile_enable', '1');
$mobile_link = get_option('contact_mobile_link', '02112345678');
$whatsapp_enable = get_option('contact_whatsapp_enable', '1');
$whatsapp_link = get_option('contact_whatsapp_link', 'https://wa.me/989123456789');
$telegram_enable = get_option('contact_telegram_enable', '1');
$telegram_link = get_option('contact_telegram_link', 'https://t.me/aradbranding');
$instagram_enable = get_option('contact_instagram_enable', '1');
$instagram_link = get_option('contact_instagram_link', 'https://instagram.com/aradbranding');
?>
<main class="contact-main-section">
  <h1 class="contact-title">تماس با ما</h1>
  <div class="contact-flexbox">
    <div class="contact-info">
      <?php if($email_enable && $email_link): ?>
      <div class="contact-method">
        <span class="contact-icon-img"><img src="<?php echo get_template_directory_uri(); ?>/images/envelope.png" width="22" height="22" alt="ایمیل"></span> 
        <a href="mailto:<?php echo esc_attr($email_link); ?>"><?php echo esc_html($email_link); ?></a>
      </div>
      <?php endif; ?>
      
      <?php if($mobile_enable && $mobile_link): ?>
      <div class="contact-method">
        <span class="contact-icon-img"><img src="<?php echo get_template_directory_uri(); ?>/images/mobile.png" width="22" height="22" alt="تلفن"></span> 
        <a href="tel:<?php echo esc_attr($mobile_link); ?>"><?php echo esc_html($mobile_link); ?></a>
      </div>
      <?php endif; ?>
      
      <?php if($whatsapp_enable && $whatsapp_link): ?>
      <div class="contact-method">
        <span class="contact-icon-img"><img src="<?php echo get_template_directory_uri(); ?>/images/whatsapp.png" width="22" height="22" alt="واتساپ"></span> 
        <a href="<?php echo esc_url($whatsapp_link); ?>" target="_blank" rel="noopener">واتساپ</a>
      </div>
      <?php endif; ?>
      
      <?php if($telegram_enable && $telegram_link): ?>
      <div class="contact-method">
        <span class="contact-icon-img"><img src="<?php echo get_template_directory_uri(); ?>/images/telegram.png" width="22" height="22" alt="تلگرام"></span> 
        <a href="<?php echo esc_url($telegram_link); ?>" target="_blank" rel="noopener">تلگرام</a>
      </div>
      <?php endif; ?>
      
      <?php if($instagram_enable && $instagram_link): ?>
      <div class="contact-method">
        <span class="contact-icon-img"><img src="<?php echo get_template_directory_uri(); ?>/images/instagram.png" width="22" height="22" alt="اینستاگرام"></span> 
        <a href="<?php echo esc_url($instagram_link); ?>" target="_blank" rel="noopener">اینستاگرام</a>
      </div>
      <?php endif; ?>
    </div>
    <form class="contact-form" method="post" style="direction:rtl;" autocomplete="off">
      <h2 class="form-title">فرم تماس سریع</h2>
      <label>نام: <input type="text" name="cf_name" required></label>
      <label>ایمیل: <input type="email" name="cf_email" required></label>
      <label>پیام شما:<textarea name="cf_message" rows="5" required></textarea></label>
      <?php $a=rand(1,9); $b=rand(1,9); $op=(rand(0,1)?'+':'*'); $ans=($op=='+')?$a+$b:$a*$b; ?>
      <label>کد امنیتی: <span class="captcha-question" style="background:#f6e6b8;color:#934b00;padding:1.5px 8px 2.5px 8px;font-weight:bold;border-radius:8px;font-size:1.13em;letter-spacing:2px;user-select:none;display:inline-block;"> <?php echo $a.' '.$op.' '.$b.' = ?'; ?> </span>
        <input style="width:56px;display:inline-block" type="text" name="cf_captcha_user" maxlength="3" required placeholder="پاسخ">
        <div class="captcha-error" style="color:#b31321;font-weight:700;font-size:13px;line-height:1.85"></div>
      </label>
      <input type="hidden" name="cf_captcha_op" value="<?php echo $op; ?>" />
      <input type="hidden" name="cf_captcha_a" value="<?php echo $a; ?>" />
      <input type="hidden" name="cf_captcha_b" value="<?php echo $b; ?>" />
      <button class="contact-btn" type="submit">ارسال پیام</button>
      <div class="form-status"></div>
    </form>
  </div>
</main>
<style>
.contact-main-section{background:#f7fafc;border-radius:20px;box-shadow:0 12px 50px rgba(15,48,87,0.08);padding:34px 28px 40px;margin:44px auto;max-width:820px;}
.contact-title{text-align:center;font-size:2.05rem;font-weight:800;color:#262626;margin-bottom:30px;letter-spacing:-0.3px;}
.contact-flexbox{display:flex;gap:50px;align-items:flex-start;justify-content:space-between;flex-wrap:wrap;}
.contact-info{flex:1;min-width:240px;display:flex;flex-direction:column;gap:16px;font-size:1.03rem;direction:rtl;}
.contact-method{width:100%;background:#fff;border-radius:12px;padding:12px 18px;font-weight:700;box-shadow:0 14px 32px rgba(44,69,122,0.08);color:#262726;transition:transform 0.18s ease,box-shadow 0.18s ease;display:flex;align-items:center;gap:10px;}
.contact-method:hover{transform:translateY(-2px);box-shadow:0 16px 35px rgba(44,69,122,0.14);}
.contact-method a{color:#222;font-weight:500;text-decoration:none;transition:color 0.18s ease;}
.contact-method a:hover{color:#faaf40;}
.contact-icon-img{width:26px;height:26px;display:inline-flex;align-items:center;justify-content:center;border-radius:8px;background:rgba(250,175,64,0.12);}
.contact-icon-img img{width:20px;height:20px;}
.contact-form{flex:1.2;min-width:260px;background:#fff;border-radius:16px;padding:28px 26px 26px;box-shadow:0 24px 48px rgba(55,71,90,0.12);display:flex;flex-direction:column;gap:16px;max-width:440px;}
.form-title{text-align:right;font-weight:800;font-size:1.12rem;color:#363636;margin-bottom:4px;}
.contact-form label{font-weight:700;font-size:0.98em;color:#444;display:flex;flex-direction:column;gap:6px;}
.contact-form input,.contact-form textarea{margin-top:2px;background:#f4f4fb;border:1px solid #d9d9e2;border-radius:9px;padding:10px 12px;font-size:0.97em;box-sizing:border-box;transition:border-color 0.18s ease,box-shadow 0.18s ease;}
.contact-form textarea{resize:vertical;min-height:150px;}
.contact-form input:focus,.contact-form textarea:focus{border:1.5px solid #faaf40;background:#fefcf7;outline:none;box-shadow:0 0 0 3px rgba(250,175,64,0.18);}
.contact-form label .captcha-question{display:inline-flex !important;align-items:center;justify-content:center;margin-top:6px;}
.contact-form label input[name="cf_captcha_user"]{margin-top:6px;}
.contact-btn{cursor:pointer;border:none;background:<?php echo esc_attr($btn_bg); ?>;color:<?php echo esc_attr($btn_text); ?>;font-size:1.13em;font-weight:600;border-radius:10px;padding:12px 26px;transition:transform 0.16s ease,background 0.2s ease,box-shadow 0.2s ease;box-shadow:0 15px 35px rgba(250,175,64,0.32);margin-top:6px;}
.contact-btn:hover{background:<?php echo esc_attr($btn_hover); ?>;color:<?php echo esc_attr($btn_text); ?>;transform:translateY(-1px);box-shadow:0 18px 38px rgba(250,175,64,0.35);}
.form-status{min-height:25px;font-size:16px;color:#217645;text-align:center;margin-top:12px;font-weight:700;padding:12px;border-radius:10px;transition:all 0.3s ease;}
.form-status.success{background:#e8f5e8;border:2px solid #4caf50;color:#2e7d32;font-size:17px;box-shadow:0 3px 12px rgba(76,175,80,0.3);animation:successPulse 0.6s ease-out;}
@keyframes successPulse{0%{transform:scale(0.95);opacity:0.7;}50%{transform:scale(1.02);}100%{transform:scale(1);opacity:1;}}
.captcha-error{min-height:20px;margin-top:4px;}
.captcha-input-invalid{border:1.7px solid #f21d49 !important;background:#fff4f4 !important;box-shadow:0 0 0 2px #ffd0db;}
@media (max-width:960px){
  .contact-main-section{margin:30px 18px;padding:30px 22px 36px;}
  .contact-flexbox{flex-direction:column;gap:26px;align-items:stretch;}
  .contact-info,.contact-form{width:100%;max-width:100%;}
  .contact-info{order:1;}
  .contact-form{order:2;}
}
@media (max-width:680px){
  .contact-main-section{margin:26px 14px;padding:26px 18px 30px;border-radius:16px;}
  .contact-title{font-size:1.8rem;margin-bottom:22px;}
  .contact-method{padding:10px 14px;font-size:0.98rem;}
  .contact-form{padding:24px 18px 22px;gap:14px;box-shadow:0 18px 38px rgba(55,71,90,0.12);}
  .contact-form input,.contact-form textarea{font-size:0.95rem;padding:9px 11px;}
  .contact-form label input[name="cf_captcha_user"]{width:100% !important;max-width:160px;margin-top:8px;}
}
@media (max-width:480px){
  .contact-main-section{margin:22px 10px;padding:24px 14px 28px;border-radius:14px;}
  .contact-title{font-size:1.65rem;margin-bottom:18px;}
  .contact-method{padding:9px 12px;font-size:0.95rem;gap:8px;}
  .contact-icon-img{width:24px;height:24px;}
  .contact-form{padding:22px 16px 20px;border-radius:14px;}
  .contact-btn{width:100%;font-size:1.05rem;}
}
</style>
<script>
function refreshCaptcha() {
  const a = Math.floor(Math.random() * 9) + 1;
  const b = Math.floor(Math.random() * 9) + 1;
  const op = Math.random() > 0.5 ? '+' : '*';
  
  document.querySelector('.captcha-question').textContent = a + ' ' + op + ' ' + b + ' = ?';
  document.querySelector('input[name="cf_captcha_op"]').value = op;
  document.querySelector('input[name="cf_captcha_a"]').value = a;
  document.querySelector('input[name="cf_captcha_b"]').value = b;
  document.querySelector('input[name="cf_captcha_user"]').value = '';
}

const form = document.querySelector('.contact-form');
if(form) {
form.addEventListener('submit',async function(e){
  e.preventDefault();
  let btn = form.querySelector('.contact-btn');
  btn.disabled = true;
  const statusDiv = form.querySelector('.form-status');
  const captchaInput = form.querySelector('input[name="cf_captcha_user"]');
  const captchaError = form.querySelector('.captcha-error');
  captchaInput.classList.remove('captcha-input-invalid');
  captchaError.textContent='';
  statusDiv.textContent = 'در حال ارسال...';
  statusDiv.className = 'form-status';
  let fd = new FormData(form);
  let res = await fetch('<?php echo admin_url('admin-ajax.php'); ?>', {
    method: 'POST',
    body: new URLSearchParams({
      action:'abad_save_contact_form',
      name:fd.get('cf_name'),
      email:fd.get('cf_email'),
      message:fd.get('cf_message'),
      cf_captcha_user:fd.get('cf_captcha_user'),
      cf_captcha_op:fd.get('cf_captcha_op'),
      cf_captcha_a:fd.get('cf_captcha_a'),
      cf_captcha_b:fd.get('cf_captcha_b')
    })
  });
  let data=await res.json();
  if(data.success) {
    statusDiv.textContent = '✅ پیام شما با موفقیت ثبت شد!';
    statusDiv.className = 'form-status success';
    form.reset();
    captchaInput.classList.remove('captcha-input-invalid');
    captchaError.textContent='';
    // پاک کردن پیام بعد از 5 ثانیه
    setTimeout(() => {
      statusDiv.textContent = '';
      statusDiv.className = 'form-status';
    }, 5000);
  } else {
    let msg = (data && data.data && data.data.message) ? data.data.message : '';
    if(data.data && data.data.captcha_error === true) {
        captchaInput.classList.add('captcha-input-invalid');
        captchaError.textContent = msg;
        statusDiv.textContent = '';
        refreshCaptcha();
        captchaInput.focus();
    } else {
        captchaInput.classList.remove('captcha-input-invalid');
        captchaError.textContent = '';
        statusDiv.textContent = (msg || 'خطا در ارسال، لطفا دوباره تلاش کنید.');
    }
  }
  btn.disabled = false;
}); }
</script>
<?php get_footer(); ?>
