<?php get_header(); ?>
<?php
$pid = get_the_ID();
$title = get_the_title();
$desc = apply_filters('the_content', get_the_content());
$ptype = get_post_meta($pid, '_abad_price_type', true) ?: 'fixed';
$price = get_post_meta($pid, '_abad_price', true);
$price_from = get_post_meta($pid, '_abad_price_from', true);
$price_to = get_post_meta($pid, '_abad_price_to', true);
$size = get_post_meta($pid, '_abad_size', true);
$pack = get_post_meta($pid, '_abad_pack', true);
$deliver = get_post_meta($pid, '_abad_deliver', true);
$pay = get_post_meta($pid, '_abad_pay', true);
$table = get_post_meta($pid, '_abad_price_table', true);
$gallery = get_post_meta($pid, '_abad_gallery', true);
if (!is_array($gallery)) $gallery = [];
// تابع اعداد فارسی
if (!function_exists('persian_number_format')) {
function persian_number_format($number) {
    $persian_numbers = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'];
    $english_numbers = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'];
    $formatted = number_format($number);
    return str_replace($english_numbers, $persian_numbers, $formatted);
}}
$price_html = '';
if($ptype === 'fixed')
  $price_html = $price ? persian_number_format($price).' تومان' : '';
elseif($ptype === 'range')
  $price_html = ($price_from && $price_to) ? 'از '.persian_number_format($price_from).' تا '.persian_number_format($price_to).' تومان' : '';
else if($ptype === 'tavafoghi')
  $price_html = 'توافقی';
$mainImg = get_the_post_thumbnail_url($pid, 'large') ?: (isset($gallery[0]) ? $gallery[0] : 'https://via.placeholder.com/600x400?text=No+Image');
?>
<main class="single-product-page v2" style="max-width:1456px;margin:0px auto 16px;padding:0 4px 0px 4px;">
  <div class="custom-single-product-grid">
    <!-- چپ: عکس بزرگ و گالری کوچک -->
    <div class="gallery-side">
      <div class="big-img-wrap"><img class="main-img" src="<?php echo esc_url($mainImg); ?>" alt="<?php echo esc_attr($title); ?>"></div>
      <?php if(count($gallery)>1): ?>
      <div class="thumbs">
        <?php foreach($gallery as $url): ?>
        <img src="<?php echo esc_url($url); ?>" onclick="document.querySelector('.main-img').src=this.src"/>
        <?php endforeach; ?>
      </div>
      <?php endif; ?>
    </div>
    <!-- راست: تیتر، توضیح و ویژگی‌ها -->
    <div class="info-side">
      <h1 class="product-title"><?php echo esc_html($title); ?></h1>
      <div class="product-desc"><?php echo $desc; ?></div>
      <table class="keyvals-table">
        <tr><td><span class="icon-p icon-dollar"><?php
          $svg = file_get_contents(get_template_directory() . '/images/dollar.svg');
          $svg = preg_replace('/<svg([^>]+)>/', '<svg$1 width="20" height="20">', $svg); echo $svg;
        ?></span><b>قیمت:</b></td><td><?php echo $price_html; ?></td></tr>
        <?php if($size): ?><tr><td><span class="icon-p"><?php 
          $svg = file_get_contents(get_template_directory() . '/images/weight.svg');
          $svg = preg_replace('/<svg([^>]+)>/', '<svg$1 width="17" height="17">', $svg); echo $svg;
        ?></span><b>اندازه:</b></td><td><?php echo esc_html($size); ?></td></tr><?php endif; ?>
        <?php if($pack): ?><tr><td><span class="icon-p"><?php 
          $svg = file_get_contents(get_template_directory() . '/images/pack.svg');
          $svg = preg_replace('/<svg([^>]+)>/', '<svg$1 width="17" height="17">', $svg); echo $svg;
        ?></span><b>بسته بندی:</b></td><td><?php echo esc_html($pack); ?></td></tr><?php endif; ?>
        <?php if($deliver): ?><tr><td><span class="icon-p"><?php 
          $svg = file_get_contents(get_template_directory() . '/images/truck.svg');
          $svg = preg_replace('/<svg([^>]+)>/', '<svg$1 width="17" height="17">', $svg); echo $svg;
        ?></span><b>تحویل:</b></td><td><?php echo esc_html($deliver); ?></td></tr><?php endif; ?>
        <?php if($pay): ?><tr><td><span class="icon-p"><?php 
          $svg = file_get_contents(get_template_directory() . '/images/payment.svg');
          $svg = preg_replace('/<svg([^>]+)>/', '<svg$1 width="17" height="17">', $svg); echo $svg;
        ?></span><b>پرداخت:</b></td><td><?php echo esc_html($pay); ?></td></tr><?php endif; ?>
      </table>
      <?php if(!empty($table) && is_array($table)): ?>
      <div class="product-table-wrap">
        <table class="product-table">
          <thead><tr><th>شرایط سفارش</th><th>قیمت (تومان)</th></tr></thead>
          <tbody>
          <?php foreach($table as $row): ?>
            <tr><td><?php echo esc_html($row[0]); ?></td><td><?php echo persian_number_format($row[1]); ?></td></tr>
          <?php endforeach; ?>
          </tbody>
        </table>
      </div>
      <?php endif; ?>

      <?php
  // --- نمایش اطلاعات مالک سایت ---
  $oname = get_option('abad_owner_name','');
  $ophone = get_option('abad_owner_phone','');
  $oimg = get_option('abad_owner_avatar','');
  $btn_text = get_option('abad_owner_button_text','تماس');
  $btn_bg = get_option('abad_owner_button_bg','#d4a849');
  $btn_text_color = get_option('abad_owner_button_text_color','#000000');
  if($oname || $ophone || $oimg): ?>
    <div class="abad-owner-contact-box">
      <div class="owner-info-wrapper">
       <div class="owner-info-wrapper-inner">
        <?php if($oimg): ?>
          <img src="<?php echo esc_url($oimg); ?>" alt="<?php echo esc_attr($oname); ?>" class="owner-avatar"/>
        <?php endif; ?>
        <?php if($oname): ?>
          <h3 class="owner-name"><?php echo esc_html($oname); ?></h3>
        <?php endif; ?>
       </div>
        <?php if($ophone): ?>
          <a href="tel:<?php echo esc_attr(preg_replace('/[^0-9+]/', '', $ophone)); ?>" class="btn-contact-owner">
           <?php echo esc_html($btn_text); ?>
          </a>
        <?php endif; ?>
      </div>
    </div>
    <style>
    .abad-owner-contact-box {
      width: 100%;
      margin: 0 auto 10px;
      background: #ffffff;
      border: 1px solid #e5e5e5;
      border-radius: 12px;
      padding: 10px;
      box-shadow: 0 2px 12px rgba(0,0,0,0.08);
      direction: rtl;
    }
    .owner-info-wrapper-inner {
      display: flex;
      flex-direction: row;
      align-items: center;
      gap: 16px;
    }
    .owner-info-wrapper {
      display: flex;
      flex-direction: row;
      align-items: center;
      gap: 16px;
      justify-content: space-between;
    }
    .owner-avatar {
      width: 100px;
      height: 100px;
      border-radius: 50%;
      object-fit: cover;
      border: 3px solid #f5f5f5;
      box-shadow: 0 4px 12px rgba(0,0,0,0.1);
    }
    .owner-name {
      font-size: 1.3rem;
      font-weight: 700;
      color: #2c2c2c;
      margin: 0;
      text-align: center;
    }
    .btn-contact-owner {
      display: inline-block;
      background: <?php echo esc_attr($btn_bg); ?>;
      color: <?php echo esc_attr($btn_text_color); ?>;
      font-weight: 700;
      font-size: 1.1rem;
      padding: 10px 15px;
      border-radius: 8px;
      text-decoration: none;
      transition: all 0.3s ease;
      box-shadow: 0 4px 12px rgba(0,0,0,0.15);
      text-align: center;
      min-width: 60px;
    }
    .btn-contact-owner:hover {
      transform: translateY(-2px);
      box-shadow: 0 6px 16px rgba(0,0,0,0.25);
      opacity: 0.9;
    }
    @media (max-width: 600px) {
      /* .abad-owner-contact-box {
        margin: 5px 12px;
      } */
      .owner-avatar {
        width: 80px;
        height: 80px;
      }
      .owner-name {
        font-size: 1.15rem;
      }
      .btn-contact-owner {
        font-size: 1rem;
        padding: 10px 15px;
        min-width: 60px;
      }
    }
    </style>
  <?php endif; ?>
    </div>
  </div>

 
</main>
<style>
.single-product-page.v2{background:#fafbfc;border-radius:13px;box-shadow:0 2px 18px #b5b5b515;}
.custom-single-product-grid{display:flex;gap:10px;padding:20px;align-items:flex-start;}
.gallery-side{flex:1;display:flex;flex-direction:column;align-items:center;gap:8px;min-width:305px;max-width:50%;}
.big-img-wrap{background:#fff;border-radius:14px;box-shadow:0 3px 17px #cccccc0c;padding:14px 8px;margin-bottom:11px;min-height:330px;display:flex;align-items:center;justify-content:center;}
.gallery-side img.main-img {
  width:100%;
  /* max-width:600px; */
  height:400px;
  max-height:400px;
  aspect-ratio:4/2;
  border-radius:13px;
  box-shadow: 0 8px 26px #0001;
  transition: .19s;
  object-fit:cover;
  background:#f3f3f3;
}
.thumbs{display:flex;gap:11px;margin-top:0;}
.thumbs img{height:62px;width:62px;border-radius:8px;object-fit:cover;background:#fafafa;box-shadow:0 1px 7px #8181810a;cursor:pointer;opacity:.87;transition:.13s;border:2px solid #dde2ee;margin-top:2px;}
.thumbs img:hover,.thumbs img:focus,.thumbs img.selected{opacity:1;border-color:#faaf40;background:#fff4db;}
.info-side{flex:1;padding-right:8px;display:flex;flex-direction:column;gap:5px;align-items:flex-start;justify-content:flex-start;max-width:50%;border: 1px solid #ddd; border-radius: 10px; padding: 5px 10px;}
.product-title{font-size:1.45rem;font-weight:800;line-height:1.7;margin-bottom:0;color:#222;}
.product-desc{font-size:14px;line-height:2.1;color:#24232e;background:#f7f7fa;border-radius:7px;padding:13px 3px;max-width:925px;}
.keyvals-table{width: 100%;display:flex; border-collapse:separate;margin:5px 0;min-width:260px;font-size: 13px;}
.keyvals-table tr {display: flex; justify-content: space-between;}
.keyvals-table td{font-size:13px;font-weight: 600;padding:2.5px 12px 2.5px 0;color:#232342;background:transparent;text-align:right;border:none;vertical-align:middle;min-width:85px;}
.keyvals-table td b{margin-right:5px;}
.keyvals-table .icon-p{font-size:1.14em;opacity:.78;margin-left:6px;vertical-align:middle;}
.product-table-wrap{margin-top:11px;background:#fff0ee;padding:13px 7px 2px 7px;border-radius:10px;box-shadow:0 2px 9px #bb8a8a13;overflow-x:auto;}
.product-table{border-collapse:collapse;width:100%;min-width:270px;}
.product-table th,.product-table td{font-size:1em;padding:9px 14px 8px 4px;border:1px solid #e2ced5;text-align:right;background:#fff;}
.product-table th{background:#b3006d;color:#fff;font-size:1.08em;}
.keyvals-table .icon-dollar svg {width:20px !important;height:20px !important;min-width:20px;min-height:20px;vertical-align:-2px;margin-left:2px;margin-right:0;display:inline-block;}
.keyvals-table .icon-p svg {width:17px !important;height:17px !important;min-width:17px;min-height:17px;vertical-align:-2px;margin-left:2px;margin-right:0;display:inline-block;fill:#000;}
.keyvals-table tbody{width: 100%;display: flex; flex-direction: column; gap: 5px;}
@media(max-width:1100px){.custom-single-product-grid{flex-direction:column;gap:30px;padding:13px;}.gallery-side,.info-side{max-width:100%;}}
</style>
<?php get_footer(); ?>
