<?php get_header(); ?>
<?php
// دریافت تمام تنظیمات صفحه single
$title_color = get_option('single_title_color', '#2c3e50');
$bg_color = get_option('single_bg_color', '#fff');
$text_color = get_option('single_text_color', '#2c3e50');
$line_color = get_option('single_line_color', '#f1ecf3');
$meta_bg = get_option('single_meta_bg', '#f6f4fc');
$meta_text = get_option('single_meta_text', '#6d488f');
$share_bg = get_option('single_share_bg', '#f093fb');
$share_btn = get_option('single_share_btn', 'rgba(255,255,255,0.2)');
$comments_bg = get_option('single_comments_bg', '#fff');
$show_category = get_option('single_show_category', 1);
$show_author = get_option('single_show_author', 1);
$show_date = get_option('single_show_date', 1);
$show_read_time = get_option('single_show_read_time', 1);
$show_share = get_option('single_show_share', 1);
$show_comments = get_option('single_show_comments', 1);
$show_related = get_option('single_show_related', 1);
$show_tags = get_option('single_show_tags', 1);
function persian_number_format($number) {
    $persian_numbers = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'];
    $english_numbers = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'];
    return str_replace($english_numbers, $persian_numbers, $number);
}
?>

<?php if (have_posts()) : while (have_posts()) : the_post(); ?>

<!-- Hero Section - عکس تمام صفحه با تیتر روی آن -->
<section class="post-hero-fullwidth">
    <?php if (has_post_thumbnail()) : ?>
        <div class="hero-image-wrapper">
            <?php the_post_thumbnail('full', ['class' => 'hero-image']); ?>
            <div class="hero-overlay"></div>
        </div>
    <?php endif; ?>
    
    <div class="hero-content-wrapper">
        <div class="hero-content-inner">
            <!-- دسته‌بندی -->
            <?php if($show_category): $categories = get_the_category(); if ($categories) : ?>
                <div class="hero-category">
                    <a href="<?php echo esc_url(get_category_link($categories[0]->term_id)); ?>">
                        <?php echo esc_html($categories[0]->name); ?>
                    </a>
                </div>
            <?php endif; endif; ?>
            
            <!-- تیتر مقاله -->
            <h1 class="hero-title" style="color:<?php echo esc_attr($title_color) ?>;">
                <?php the_title(); ?>
            </h1>
            
            <!-- متادیتا -->
            <div class="hero-meta" style="color:<?php echo esc_attr($meta_text) ?>;">
                <?php if($show_author): ?>
                    <div class="hero-meta-item author-meta">
                        <?php echo get_avatar(get_the_author_meta('ID'), 40, '', '', ['class'=>'author-avatar-hero']); ?>
                        <span class="author-name-hero"><?php the_author(); ?></span>
                    </div>
                <?php endif; ?>
                
                <?php if($show_date): ?>
                    <div class="hero-meta-item">
                        <svg width="18" height="18" fill="currentColor" viewBox="0 0 24 24"><path d="M19 4h-1V2h-2v2H8V2H6v2H5c-1.11 0-1.99.9-1.99 2L3 20c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 16H5V10h14v10z"/></svg>
                        <span><?php echo persian_number_format(get_the_date('d F Y')); ?></span>
                    </div>
                <?php endif; ?>
                
                <?php if($show_read_time): ?>
                    <div class="hero-meta-item">
                        <svg width="18" height="18" fill="currentColor" viewBox="0 0 24 24"><path d="M11.99 2C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8zm.5-13H11v6l5.25 3.15.75-1.23-4.5-2.67z"/></svg>
                        <span><?php echo persian_number_format(ceil(str_word_count(strip_tags(get_the_content())) / 200)); ?> دقیقه مطالعه</span>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>

<!-- محتوای اصلی -->
<main class="post-main-fullwidth" style="background:<?php echo esc_attr($bg_color) ?>;">
    <div class="post-container-wide">
        
        <!-- محتوای مقاله -->
        <article class="post-content-fullwidth" style="color:<?php echo esc_attr($text_color) ?>;">
            <?php the_content(); ?>
        </article>
        
        <!-- تگ‌ها و اشتراک‌گذاری -->
        <div class="post-footer-section">
            <!-- تگ‌ها -->
            <?php if($show_tags): $tags = get_the_tags(); if ($tags) : ?>
                <div class="tags-section-wide">
                    <span class="tags-label-wide">🏷️ برچسب‌ها:</span>
                    <div class="tags-list-wide">
                        <?php foreach ($tags as $tag) : ?>
                            <a href="<?php echo esc_url(get_tag_link($tag->term_id)); ?>" class="tag-wide">
                                <?php echo esc_html($tag->name); ?>
                            </a>
                        <?php endforeach; ?>
                    </div>
                </div>
            <?php endif; endif; ?>
            
            <!-- اشتراک‌گذاری -->
            <?php if($show_share): ?>
                <div class="share-section-wide" style="background:<?php echo esc_attr($share_bg) ?>;">
                    <h3 class="share-title-wide">این مطلب را با دوستان خود به اشتراک بگذارید</h3>
                    <div class="share-buttons-wide">
                        <a href="https://telegram.me/share/url?url=<?php echo urlencode(get_permalink()); ?>&text=<?php echo urlencode(get_the_title()); ?>"
                           target="_blank" class="share-btn-wide telegram" style="background:<?php echo esc_attr($share_btn) ?>;">
                            <svg width="24" height="24" fill="currentColor" viewBox="0 0 24 24"><path d="M12 0C5.373 0 0 5.373 0 12s5.373 12 12 12 12-5.373 12-12S18.627 0 12 0zm5.562 8.161l-1.84 8.673c-.139.623-.506.775-.998.483l-2.754-2.03-1.327 1.278c-.147.147-.27.27-.553.27l.197-2.8 5.095-4.603c.222-.197-.048-.307-.344-.11l-6.298 3.966-2.713-.848c-.591-.183-.603-.591.125-.875l10.605-4.086c.492-.183.923.11.762.874z"/></svg>
                            تلگرام
                        </a>
                        <a href="https://wa.me/?text=<?php echo urlencode(get_the_title() . ' - ' . get_permalink()); ?>"
                           target="_blank" class="share-btn-wide whatsapp" style="background:<?php echo esc_attr($share_btn) ?>;">
                            <svg width="24" height="24" fill="currentColor" viewBox="0 0 24 24"><path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893a11.821 11.821 0 00-3.48-8.413Z"/></svg>
                            واتساپ
                        </a>
                        <a href="javascript:void(0)" onclick="copyToClipboard('<?php echo get_permalink(); ?>')"
                           class="share-btn-wide copy" style="background:<?php echo esc_attr($share_btn) ?>;">
                            <svg width="24" height="24" fill="currentColor" viewBox="0 0 24 24"><path d="M16 1H4c-1.1 0-2 .9-2 2v14h2V3h12V1zm3 4H8c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h11c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2zm0 16H8V7h11v14z"/></svg>
                            کپی لینک
                        </a>
                    </div>
                </div>
            <?php endif; ?>
        </div>
        
        <!-- ناوبری مقالات -->
        <nav class="post-navigation-wide">
            <?php
            $prev_post = get_previous_post();
            $next_post = get_next_post();
            if ($prev_post || $next_post) :
            ?>
                <?php if ($prev_post) : ?>
                    <a href="<?php echo get_permalink($prev_post); ?>" class="nav-card-wide prev-card">
                        <span class="nav-arrow-wide">→</span>
                        <div class="nav-text-wide">
                            <span class="nav-label-wide">مقاله قبلی</span>
                            <span class="nav-title-wide"><?php echo get_the_title($prev_post); ?></span>
                        </div>
                    </a>
                <?php endif; ?>
                
                <?php if ($next_post) : ?>
                    <a href="<?php echo get_permalink($next_post); ?>" class="nav-card-wide next-card">
                        <div class="nav-text-wide">
                            <span class="nav-label-wide">مقاله بعدی</span>
                            <span class="nav-title-wide"><?php echo get_the_title($next_post); ?></span>
                        </div>
                        <span class="nav-arrow-wide">←</span>
                    </a>
                <?php endif; ?>
            <?php endif; ?>
        </nav>
        
        <!-- مقالات مرتبط -->
        <?php if($show_related):
        $related_posts = get_posts([
            'category__in' => wp_get_post_categories(get_the_ID()),
            'numberposts' => 3,
            'post__not_in' => [get_the_ID()],
        ]);
        if ($related_posts) : ?>
            <section class="related-section-wide">
                <h3 class="related-title-wide">📚 مقالات مرتبط</h3>
                <div class="related-grid-wide">
                    <?php foreach ($related_posts as $related) : ?>
                        <article class="related-card-wide">
                            <a href="<?php echo get_permalink($related); ?>" class="related-link-wide">
                                <?php if (has_post_thumbnail($related->ID)) : ?>
                                    <div class="related-thumb-wide">
                                        <?php echo get_the_post_thumbnail($related->ID, 'large'); ?>
                                        <div class="related-overlay-wide"></div>
                                    </div>
                                <?php endif; ?>
                                <div class="related-body-wide">
                                    <h4 class="related-card-title"><?php echo get_the_title($related); ?></h4>
                                    <time class="related-card-date"><?php echo persian_number_format(get_the_date('d F Y', $related)); ?></time>
                                </div>
                            </a>
                        </article>
                    <?php endforeach; ?>
                </div>
            </section>
        <?php endif; endif; ?>
        
        <!-- بخش نظرات -->
        <?php if($show_comments && (comments_open() || get_comments_number())) : ?>
            <section class="comments-section-wide">
                <?php comments_template(); ?>
            </section>
        <?php endif; ?>
        
    </div>
</main>

<style>
/* ===== طراحی مدرن تمام صفحه ===== */
* { box-sizing: border-box; }

/* Hero Section - عکس تمام صفحه */
.post-hero-fullwidth {
    position: relative;
    width: 100%;
    height: 75vh;
    min-height: 600px;
    overflow: hidden;
    background: #000;
}

.hero-image-wrapper {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
}

.hero-image {
    width: 100%;
    height: 100%;
    object-fit: cover;
    object-position: center;
}

.hero-overlay {
    position: absolute;
    inset: 0;
    background: linear-gradient(to top, rgba(0,0,0,0.8) 0%, rgba(0,0,0,0.3) 50%, rgba(0,0,0,0.5) 100%);
}

.hero-content-wrapper {
    position: absolute;
    bottom: 0;
    left: 0;
    right: 0;
    padding: 80px 40px;
    z-index: 10;
}

.hero-content-inner {
    max-width: 1200px;
    margin: 0 auto;
}

.hero-category {
    margin-bottom: 24px;
}

.hero-category a {
    display: inline-block;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 10px 28px;
    border-radius: 50px;
    font-weight: 700;
    font-size: 0.95rem;
    text-decoration: none;
    box-shadow: 0 4px 20px rgba(102, 126, 234, 0.5);
    transition: all 0.3s ease;
}

.hero-category a:hover {
    transform: translateY(-3px);
    box-shadow: 0 6px 30px rgba(102, 126, 234, 0.7);
}

.hero-title {
    font-size: 4rem;
    font-weight: 900;
    line-height: 1.15;
    color: white !important;
    margin: 0 0 32px 0;
    text-shadow: 0 4px 30px rgba(0,0,0,0.5);
    font-family: 'Vazir', sans-serif;
}

.hero-meta {
    display: flex;
    align-items: center;
    gap: 32px;
    flex-wrap: wrap;
}

.hero-meta-item {
    display: flex;
    align-items: center;
    gap: 10px;
    color: rgba(255,255,255,0.95);
    font-weight: 600;
    font-size: 1.05rem;
}

.hero-meta-item svg {
    opacity: 0.9;
}

.author-meta {
    background: rgba(255,255,255,0.15);
    backdrop-filter: blur(10px);
    padding: 8px 20px 8px 8px;
    border-radius: 50px;
    border: 1px solid rgba(255,255,255,0.2);
}

.author-avatar-hero {
    width: 40px !important;
    height: 40px !important;
    border-radius: 50%;
    border: 2px solid white;
}

.author-name-hero {
    font-weight: 700;
}

/* محتوای اصلی */
.post-main-fullwidth {
    padding: 80px 0;
}

.post-container-wide {
    max-width: 1200px;
    margin: 0 auto;
    padding: 0 40px;
}

.post-content-fullwidth {
    background: white;
    padding: 60px 80px;
    border-radius: 24px;
    box-shadow: 0 10px 60px rgba(0,0,0,0.08);
    font-size: 1.2rem;
    line-height: 2;
    margin-bottom: 60px;
    font-family: 'Vazir', sans-serif;
}

.post-content-fullwidth p {
    margin-bottom: 28px;
    text-align: justify;
}

.post-content-fullwidth h2,
.post-content-fullwidth h3 {
    font-weight: 800;
    margin: 48px 0 24px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
}

.post-content-fullwidth h2 {
    font-size: 2.2rem;
}

.post-content-fullwidth h3 {
    font-size: 1.7rem;
}

.post-content-fullwidth img {
    max-width: 100%;
    height: auto;
    border-radius: 16px;
    margin: 40px 0;
    box-shadow: 0 10px 40px rgba(0,0,0,0.12);
}

.post-content-fullwidth blockquote {
    border-right: 6px solid #667eea;
    background: linear-gradient(135deg, #f5f7fa 0%, #e8ecf3 100%);
    padding: 32px 40px;
    margin: 40px 0;
    border-radius: 16px;
    font-style: italic;
    font-size: 1.15rem;
    box-shadow: 0 4px 20px rgba(0,0,0,0.06);
}

/* Footer Section */
.post-footer-section {
    margin-bottom: 60px;
}

/* تگ‌ها */
.tags-section-wide {
    background: white;
    padding: 32px 40px;
    border-radius: 20px;
    box-shadow: 0 8px 30px rgba(0,0,0,0.06);
    margin-bottom: 32px;
}

.tags-label-wide {
    font-size: 1.2rem;
    font-weight: 700;
    color: #2c3e50;
    display: block;
    margin-bottom: 20px;
}

.tags-list-wide {
    display: flex;
    flex-wrap: wrap;
    gap: 12px;
}

.tag-wide {
    background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
    color: white;
    padding: 10px 24px;
    border-radius: 50px;
    text-decoration: none;
    font-weight: 600;
    font-size: 0.95rem;
    transition: all 0.3s ease;
    box-shadow: 0 4px 15px rgba(240, 147, 251, 0.3);
}

.tag-wide:hover {
    transform: translateY(-3px);
    box-shadow: 0 8px 25px rgba(240, 147, 251, 0.5);
}

/* اشتراک‌گذاری */
.share-section-wide {
    padding: 48px 40px;
    border-radius: 20px;
    text-align: center;
    box-shadow: 0 10px 40px rgba(240, 147, 251, 0.3);
    margin-bottom: 60px;
}

.share-title-wide {
    color: white;
    font-size: 1.6rem;
    font-weight: 800;
    margin-bottom: 32px;
}

.share-buttons-wide {
    display: flex;
    justify-content: center;
    gap: 20px;
    flex-wrap: wrap;
}

.share-btn-wide {
    display: inline-flex;
    align-items: center;
    gap: 12px;
    padding: 16px 36px;
    border-radius: 50px;
    color: white;
    text-decoration: none;
    font-weight: 700;
    font-size: 1.05rem;
    backdrop-filter: blur(10px);
    transition: all 0.3s ease;
    box-shadow: 0 4px 20px rgba(0,0,0,0.2);
}

.share-btn-wide:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 30px rgba(0,0,0,0.3);
}

/* ناوبری مقالات */
.post-navigation-wide {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 32px;
    margin-bottom: 80px;
}

.nav-card-wide {
    background: white;
    border-radius: 20px;
    padding: 40px;
    box-shadow: 0 10px 40px rgba(0,0,0,0.08);
    text-decoration: none;
    display: flex;
    align-items: center;
    gap: 20px;
    transition: all 0.3s ease;
}

.nav-card-wide:hover {
    transform: translateY(-8px);
    box-shadow: 0 15px 50px rgba(0,0,0,0.15);
}

.nav-arrow-wide {
    font-size: 2.5rem;
    font-weight: 900;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
}

.nav-text-wide {
    display: flex;
    flex-direction: column;
    gap: 12px;
}

.nav-label-wide {
    font-size: 0.9rem;
    color: #999;
    font-weight: 600;
    text-transform: uppercase;
}

.nav-title-wide {
    font-size: 1.3rem;
    font-weight: 800;
    color: #2c3e50;
    line-height: 1.4;
}

.prev-card { justify-content: flex-start; }
.next-card { justify-content: flex-end; text-align: left; }

/* مقالات مرتبط */
.related-section-wide {
    margin-bottom: 80px;
}

.related-title-wide {
    font-size: 2.5rem;
    font-weight: 900;
    text-align: center;
    margin-bottom: 48px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
}

.related-grid-wide {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 32px;
}

.related-card-wide {
    background: white;
    border-radius: 20px;
    overflow: hidden;
    box-shadow: 0 10px 40px rgba(0,0,0,0.08);
    transition: all 0.4s ease;
}

.related-card-wide:hover {
    transform: translateY(-12px);
    box-shadow: 0 20px 60px rgba(0,0,0,0.15);
}

.related-link-wide {
    text-decoration: none;
    color: inherit;
    display: block;
}

.related-thumb-wide {
    position: relative;
    height: 260px;
    overflow: hidden;
}

.related-thumb-wide img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    transition: transform 0.6s ease;
}

.related-card-wide:hover .related-thumb-wide img {
    transform: scale(1.15);
}

.related-overlay-wide {
    position: absolute;
    inset: 0;
    background: linear-gradient(to top, rgba(0,0,0,0.6) 0%, transparent 60%);
}

.related-body-wide {
    padding: 28px;
}

.related-card-title {
    font-size: 1.25rem;
    font-weight: 700;
    color: #2c3e50;
    margin-bottom: 12px;
    line-height: 1.4;
}

.related-card-date {
    font-size: 0.95rem;
    color: #999;
    font-weight: 600;
}

/* نظرات */
.comments-section-wide {
    background: white;
    padding: 60px;
    border-radius: 24px;
    box-shadow: 0 10px 60px rgba(0,0,0,0.08);
}

/* ریسپانسیو */
@media (max-width: 1024px) {
    .hero-title { font-size: 3rem; }
    .post-container-wide { padding: 0 12px; }
    .post-content-fullwidth { padding: 40px; font-size: 1.1rem; }
    .related-grid-wide { grid-template-columns: repeat(2, 1fr); }
}

@media (max-width: 768px) {
    .post-hero-fullwidth { height: 60vh; min-height: 500px; }
    .hero-content-wrapper { padding: 40px 24px; }
    .hero-title { font-size: 2rem; }
    .hero-meta { gap: 16px; }
    .post-content-fullwidth { padding: 32px 24px; font-size: 1.05rem; }
    .post-navigation-wide { grid-template-columns: 1fr; }
    .share-buttons-wide { flex-direction: column; }
    .related-grid-wide { grid-template-columns: 1fr; }
    .comments-section-wide { padding: 32px 20px; }
}
</style>

<script>
function copyToClipboard(text) {
    navigator.clipboard.writeText(text).then(function() {
        alert('✅ لینک با موفقیت کپی شد!');
    });
}
</script>

<?php endwhile; endif; ?>
<?php get_footer(); ?>
